from paysys.sre.tools.monitorings.lib.checks.active.http import http
from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children_deploy, ttl, flaps


def get_checks(children_api, children_tasks, children_gates, balancers):
    return merge(
        l7_monitoring(balancers),
        check("certs"),
        check('pushclient_check', ttl(900, 300), flaps(180, 900)),
        unreachable,
        http('api', 8080, ok_codes=[200, 301, 302], crit=0, headers={"Host": "localhost"}),
        check('api', gen_children_deploy(children_api, 'api')),
        http('tasks', 8080, ok_codes=[200, 301, 302], crit=0, headers={"Host": "localhost"}),
        check('tasks', gen_children_deploy(children_tasks, 'tasks')),
        http('req-gate', 8080,
             ok_codes=[200, 301, 302], crit=0,
             headers={"Host": "localhost"}
             ),
        http(
            'oebs-gate', 8081,
            ok_codes=[200, 301, 302], crit=0,
            headers={"Host": "localhost"}
        ),
        check('req-gates', gen_children_deploy(children_gates, 'req-gates')),
        check('oebs-gates', gen_children_deploy(children_gates, 'oebs-gates')),
        *[
            check(x, gen_children_deploy(children_api + children_tasks + children_gates, x))
            for x in [
                'UNREACHABLE',
                'pushclient_check',
                'certs',
            ]
        ]
    )
