from paysys.sre.tools.monitorings.lib.checks.active.http import http
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children_deploy, flaps


def get_checks(children):
    return merge(
        check('unispace'),
        unreachable,
        http('event-aggregator', 8080, ok_codes=[200], crit=0, headers={"Host": "localhost"}),
        check('event-aggregator', gen_children_deploy(children['event-aggregator'], 'event-aggregator')),
        http('enqueuer', 8080, ok_codes=[200], crit=0, headers={"Host": "localhost"}),
        check('enqueuer', gen_children_deploy(children['enqueuer'], 'enqueuer')),
        http('action-worker', 8080, ok_codes=[200], crit=0, headers={"Host": "localhost"}),
        check('action-worker', gen_children_deploy(children['action-worker'], 'action-worker')),
        *[
            check(
                x, gen_children_deploy([children['event-aggregator'], children['enqueuer'], children['action-worker']], x),
                flaps(180, 600),
            )
            for x in [
                'UNREACHABLE',
                'unispace',
            ]
        ]
    )
