# coding=utf-8


import paysys.sre.tools.monitorings.configs.billing30.base.accrualer as accrualer
from paysys.sre.tools.monitorings.lib.util.aggregators import timed_more_than_limit_is_problem
from paysys.sre.tools.monitorings.lib.util.solomon import solomon_presence_expression_monitoring, \
    solomon_absence_expression_monitoring
from paysys.sre.tools.monitorings.lib.util.helpers import empty_children, merge, solomon_check
from paysys.sre.tools.monitorings.lib.notifications import Notifications, \
    FIN_TOOLS_ESCALATION_USERS, FIN_TOOLS_TELEGRAM_GROUP
from paysys.sre.tools.monitorings.lib.checks.postgres import postgres

notifications = Notifications()
notifications._telegram_default_options["status"] = ["CRIT", "WARN", "OK"]
notifications.set_iron_woman(logins=FIN_TOOLS_ESCALATION_USERS, delay=1200) \
    .set_telegram(group=FIN_TOOLS_TELEGRAM_GROUP)

annotations_present = {
    "description": "{{#isAlarm}}Total value: {{expression.total}} is above critical threshold!{{/isAlarm}}\n"
                   "{{#isWarn}}Total value: {{expression.total}} is above warn threshold{{/isWarn}}"}

annotations_absent = {
    "description": "{{#isAlarm}}Total value: {{expression.total}} is below critical threshold!{{/isAlarm}}\n"
                   "{{#isWarn}}Total value: {{expression.total}} is below warn threshold{{/isWarn}}"}

defaults = {'namespace': 'billing30.accrualer'}

# juggler
host = "billing30.accrualer"
# solomon
project_id = "newbilling-accrualer"

children = empty_children
children_tasks = ['billing-accrualer@stage=billing-accrualer-prod-stage;deploy_unit=tasks']


def checks():
    base = accrualer.get_checks(
        children_tasks,
    )

    unread_msgs = _get_lb_unread_messages()
    error_msgs = _get_error_messages_count()
    read_lag = _get_read_lag()
    acts_written_messages = _get_write_messages()

    solomons = merge(
        unread_msgs,
        error_msgs,
        read_lag,
        acts_written_messages
    )
    for val in solomons.values():
        val["aggregator_kwargs"] = merge(val.get("aggregator_kwargs", {}), {"nodata_mode": "force_warn"})

    return merge(
        base,
        solomons,
        postgres("mdblddfdjr2le1ep52dt", "accrualerdb",
                 cpu_wait_limit=2.0),
    )


def _get_lb_unread_messages():
    """
        Формирует проверку на количество непрочитанных сообщений в LB
    :return: словарь с проверкой с ключами для соломона
    """
    selectors = {
        "project": "kikimr", "cluster": "lbkx", "service": "pqtabletAggregatedCounters",
        "Account": "billing", "OriginDC": "*", "host": "*", "sensor": "TotalMessageLagByLastRead",
        "ConsumerPath": "billing/prod/events-accrual-consumer",
        "TopicPath": "billing/prod/accounts-events", "partition": "-", "user_counters": "PersQueue"
    }

    unread_msgs_expr = solomon_presence_expression_monitoring(
        window_secs=60 * 5,
        project_id=project_id,
        selectors=selectors,
        warn_threshold=100000,
        crit_threshold=200000,
        annotations=annotations_present,
        description="LB unread messages count",
        fn="max"
    )
    return solomon_check("unread-msgs-prod", unread_msgs_expr)


def _get_error_messages_count():
    """
        Формирует проверку на количество сообщений в топике unknown-event
    :return: словарь с проверкой с ключами для соломона
    """
    selectors = {
        "project": "kikimr", "cluster": "lbkx", "service": "pqproxy_writeSession",
        "Account": "billing-accrualer", "OriginDC": "cluster", "host": "cluster",
        "sensor": "MessagesWrittenOriginal", "TopicPath": "billing-accrualer/prod/errors"
    }

    msgs_count_expr = solomon_presence_expression_monitoring(
        project_id=project_id,
        selectors=selectors,
        warn_threshold=0,
        crit_threshold=0,
        annotations=annotations_present,
        description="Error topic messages count"
    )
    return solomon_check("error-topic-count", msgs_count_expr)


def _get_unknown_messages_count():
    """
        Формирует проверку на количество сообщений в топике unknown-event
    :return: словарь с проверкой с ключами для соломона
    """
    selectors = {
        "project": "kikimr", "cluster": "lbkx", "service": "pqproxy_writeSession",
        "Account": "billing-accrualer", "OriginDC": "cluster", "host": "cluster",
        "sensor": "MessagesWrittenOriginal", "TopicPath": "billing-accrualer/prod/unknown-event"
    }

    msgs_count_expr = solomon_presence_expression_monitoring(
        project_id=project_id,
        selectors=selectors,
        warn_threshold=15,
        crit_threshold=30,
        annotations=annotations_present,
        description="Unknown topic messages count"
    )
    return merge(
        solomon_check("unknown-topic-count", msgs_count_expr)
    )


def _get_read_lag():
    """
        Формирует проверку на задержку чтения из топика billing/prod/events-accrual-consumer
    :return: словарь с проверкой с ключами для соломона
    """
    selectors = {
        "Account": "billing", "ConsumerPath": "billing/prod/events-accrual-consumer",
        "TopicPath": "billing/prod/accounts-events", "cluster": "lbkx", "project": "kikimr",
        "sensor": "ReadTimeLagMs", "service": "pqtabletAggregatedCounters", "user_counters": "PersQueue"
    }
    msgs_count_expr = solomon_presence_expression_monitoring(
        project_id=project_id,
        selectors=selectors,
        warn_threshold=1000 * 30 * 60,
        crit_threshold=1000 * 60 * 60,
        annotations=annotations_present,
        description="Source events Read lag",
        fn="max",
        window_secs=60 * 5
    )
    return solomon_check("source-events-read-lag", msgs_count_expr)


def _get_write_messages():
    """
        Формирует проверку на отсутствие записанных сообщений в топик billing-accrualer/prod/acts/agent
        С 9 до 10 не проверяем, т.к. такси не шлет события
    return: словарь с проверкой с ключами для соломона
    """
    selectors = {
        "project": "kikimr", "cluster": "lbkx", "service": "pqproxy_writeSession",
        "Account": "billing-accrualer", "OriginDC": "cluster", "host": "cluster",
        "sensor": "MessagesWrittenOriginal", "TopicPath": "billing-accrualer/prod/acts/agent"
    }
    msg_count_expr = solomon_absence_expression_monitoring(
        project_id=project_id,
        selectors=selectors,
        warn_threshold=1,
        crit_threshold=1,
        annotations=annotations_absent,
        window_secs=60 * 60,
        description="Acts written messages"
    )
    # return solomon_check("acts-written-messages", msg_count_expr)
    return {
        "acts-written-messages": merge(
            {
                "solomon": msg_count_expr,
            },
            timed_more_than_limit_is_problem(limits=[
                # time_end: 8 значит до 8:59
                {"time_start": 10, "time_end": 8, "day_start": 1, "day_end": 7, "warn": 1, "crit": 1},
                # с 9 до 10 у такси технологическое окно когда они не шлют событий
                # time_end: 9 значит до 9:59
                {"time_start": 9, "time_end": 9, "day_start": 1, "day_end": 7, "warn": 0, "crit": 0},
            ])
        )
    }
