from paysys.sre.tools.monitorings.configs.billing30.base import scheduler
from paysys.sre.tools.monitorings.lib.checks.nirvana import Checks as NirvanaChecks
from paysys.sre.tools.monitorings.lib.checks.reactor import Checks as ReactorChecks
from paysys.sre.tools.monitorings.lib.notifications import Notifications
from paysys.sre.tools.monitorings.lib.util.helpers import merge

notifications_telegram = (
    Notifications()
        .set_telegram(group=["hot_billing_scheduler_notifications"], delay=30)
        .telegram
)

iron_woman_telegram_notifications = (
    Notifications()
        .set_telegram(group=["hot_billing_scheduler_notifications"], delay=30)
        .set_iron_woman(logins=['@svc_billing-core:duty-none', 'kositsyn-pa', 'lightrevan'], delay=1200)
)

notifications_telegram_and_call = (
    iron_woman_telegram_notifications.iron_woman_and_telegram
)
notifications_telegram_and_call_daytime = (
    iron_woman_telegram_notifications.iron_woman_daytime_and_telegram
)

defaults = {'namespace': 'new_billing_scheduler'}

host = "billing30.scheduler"
project_id = "new_billing_scheduler"

children = {}
for du in ['event-aggregator', 'enqueuer', 'action-worker']:
    children[du] = 'billing-scheduler@stage=billing-scheduler-prod-stage;deploy_unit={du}'.format(du=du)


def checks():
    reactor_project_id = 11220490
    reactor = ReactorChecks(project_id, reactor_project_id, project_id, notifications_telegram_and_call_daytime)
    nirvana = NirvanaChecks("billing30_hot_scheduler", project_id, notifications_telegram_and_call_daytime)

    base_checks = scheduler.get_checks(children)

    solomon_checks = merge(
        reactor.reaction_bundle(),
        reactor.reaction_instances_created_velocity(),
        reactor.running_reaction_instances_number(),
        reactor.reaction_instances_total(),
        nirvana.bundle(),
    )

    return merge(base_checks, solomon_checks)
