import paysys.sre.tools.monitorings.configs.billing30.base.tarifficator as tarifficator
from paysys.sre.tools.monitorings.lib.notifications import Notifications

# https://docs.yandex-team.ru/juggler/notifications/escalations
notifications = Notifications()
notifications.set_telegram(group=[
    '@svc_billing_swat_team:main',
    '@svc_billing_swat_team:reserve',
    'hot_billing_tarificator_notifications'
], delay=60)
notifications.set_iron_woman(logins=[
    '@svc_billing_swat_team:main',
    '@svc_billing_swat_team:reserve',
    'ozhegov',
    'dskut'
], delay=300)

defaults = {'namespace': 'billing30.tarifficator.stable'}
host = "billing30.tarifficator"

children = {
    'diod': 'billing-diod@stage=billing-diod-prod-stage;deploy_unit=diod',
    'faas': 'billing-faas@stage=billing-faas-prod-stage'
}

for du in [
    'mediator',
    'mediator-copier',
    'processor'
]:
    children[du] = 'billing-tarifficator@stage=billing-tarifficator-prod-stage;deploy_unit=%s' % du

ydb = [
    {'cluster': 'ydb_ru', 'database': '/ru/newbillingtarification/prod/diod'}
]

l7_balancers = [
    {
        "namespace": "%s.billing.yandex.net" % name,
        "datacenters": ["man", "sas", "vla"],
        "host": "%s.billing.yandex.net" % name,
        "http_ports": [80],
        "https_ports": [443],
        "services": [
            "rtc_balancer_%s_billing_yandex_net_man" % name,
            "rtc_balancer_%s_billing_yandex_net_sas" % name,
            "rtc_balancer_%s_billing_yandex_net_vla" % name,
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 10, "crit": 50}
        },
    } for name in ['processor', 'faas', 'diod']
]

CONSUMER = 'billing/prod/consumer'
topics = [
    # taxi
    tarifficator.Topic(
        'balance-zaxi',
        'balance/prod/zaxi',
        CONSUMER,
        50000, 250000  # warn, crit
    ),

    tarifficator.Topic(
        'taxi-light',
        'taxi/billing-fin-payouts/production/cash_payment_fact',
        CONSUMER,
        50000, 250000  # warn, crit
    ),

    tarifficator.Topic(
        'taxi-expenses',
        'billing/prod/expenses',
        CONSUMER,
        50000, 250000  # warn, crit
    ),
    tarifficator.Topic(
        'taxi-tlog-expenses',
        'taxi/taxi-billing-tlog/production/expenses',
        CONSUMER,
        50000, 250000  # warn, crit
    ),

    tarifficator.Topic(
        'taxi-payments',
        'billing/prod/payments',
        CONSUMER,
        50000, 250000  # warn, crit
    ),
    tarifficator.Topic(
        'taxi-tlog-payments',
        'taxi/taxi-billing-tlog/production/payments',
        CONSUMER,
        50000, 250000  # warn, crit
    ),

    tarifficator.Topic(
        'taxi-tlog-revenue',
        'taxi/taxi-billing-tlog/production/revenues',
        CONSUMER,
        50000, 250000  # warn, crit
    ),
    tarifficator.Topic(
        'taxi-revenue',
        'billing/prod/revenue',
        CONSUMER,
        50000, 250000  # warn, crit
    ),

    # bnpl
    tarifficator.Topic(
        'bnpl-billing-export-prod',
        'bnpl/backend/billing_export_prod',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'bnpl-billing-export-fee-prod',
        'bnpl/backend/billing_export_fee_prod',
        CONSUMER,
        500, 1000  # warn, crit
    ),

    # oplata
    tarifficator.Topic(
        'payments-production-tlog',
        'payments/production/tlog',
        CONSUMER,
        500, 1000  # warn, crit
    ),

    # mlp
    tarifficator.Topic(
        'mlp-overdraft',
        'mlp-overdraft/prod/credit-log',
        CONSUMER,
        500, 1000  # warn, crit
    ),

    # trust
    tarifficator.Topic(
        'trust',
        'trust/prod/payments',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'trust-pochta-pro-360',
        'billing/prod/pochta-pro-360',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'trust-music',
        'billing/prod/music',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'trust-music-mediaservices',
        'billing/prod/music_mediaservices',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'trust-aero',
        'billing/prod/aero',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'trust-disk',
        'billing/prod/disk',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'trust-games',
        'billing/prod/games',
        CONSUMER,
        500, 1000  # warn, crit
    ),
    tarifficator.Topic(
        'trust-kinopoisk-amediateka',
        'billing/prod/kinopoisk_amediateka',
        CONSUMER,
        500, 1000  # warn, crit
    ),
]


def checks():
    return tarifficator.get_checks(children, l7_balancers, 'prod', topics, ydb)
