from paysys.sre.tools.monitorings.lib.checks import services, base, doc
from paysys.sre.tools.monitorings.lib.util.helpers import gen_children, check, merge

host = "oebs.cloning"  # VIRT HOST
children_clones = ['paysys_backup_clones']  # CGROUP
children_sox = ['paysys_backup_sox']
children = children_sox


def checks():
    oebs_clones = services.locker_server.copy()
    oebs_clones.pop('locker-server')
    oebs_clones.update(check('locker-server', merge(gen_children(children, 'locker_server'), doc.doc_link('cloning.oebs.paysys'))))
    oebs_clones.update(check('failed_locks', merge(gen_children(children, 'failed_locks_sas'), gen_children(children, 'failed_locks_vla'), doc.doc_link('cloning.oebs.paysys'))))
    oebs_clones.update(check('staled_clients', merge(gen_children(children, 'staled_clients_sas'), gen_children(children, 'staled_clients_vla'), doc.doc_link('cloning.oebs.paysys'))))
    oebs_clones.update(check('staled_locks', merge(gen_children(children, 'staled_locks_sas'), gen_children(children, 'staled_locks_vla'), doc.doc_link('cloning.oebs.paysys'))))
    oebs_clones.update(check('unfetched_locks', merge(gen_children(children, 'unfetched_locks_sas'), gen_children(children, 'unfetched_locks_vla'), doc.doc_link('cloning.oebs.paysys'))))
    return merge(base.unreachable, oebs_clones, services.nginx)
