from paysys.sre.tools.monitorings.lib.checks.active.http import https
from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children_deploy, flaps


def get_checks(children, balancers):
    return merge(
        l7_monitoring(balancers),
        check('certs'),
        check('unispace'),
        unreachable,
        https('api', 443, ok_codes=[200], crit=0, headers={"Host": "localhost"}),
        check('api', gen_children_deploy(children['api'], 'api')),
        https('infratasks', 443, ok_codes=[200], crit=0, headers={"Host": "localhost"}),
        check('infratasks', gen_children_deploy(children['infratasks'], 'infratasks')),
        https('tasks', 443, ok_codes=[200], crit=0, headers={"Host": "localhost"}),
        check('tasks', gen_children_deploy(children['tasks'], 'tasks')),
        *[
            check(
                x, gen_children_deploy([children['api'], children['infratasks'], children['tasks']], x),
                flaps(180, 600),
            )
            for x in [
                'UNREACHABLE',
                'certs',
                'unispace',
            ]
        ]
    )
