from paysys.sre.tools.monitorings.lib.util.helpers import merge, flaps, ttl, check, gen_children, unreach_skip, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip
from paysys.sre.tools.monitorings.lib.checks import base, services

host = "crm.stable.db"  # VIRT HOST
children = ['crm_prod_db']  # CGROUP

exclude_db_checks = ['shared_pool_free_mem']

exclude_rac_checks = ['oracle-patches']


def checks():
    database_result = services.oracle_database.copy()
    [database_result.pop(exclude) for exclude in exclude_db_checks]

    rac_result = services.oracle_rac.copy()
    [rac_result.pop(exclude) for exclude in exclude_rac_checks]

    result = merge(base.common_fin_fin(children),
                   services.audit,
                   rac_result,
                   database_result,
                   services.pipeline_sender,
                   check('seq-check', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   check('oracle-balance-patches', merge(ttl(5400, 3600), logic_or, unreach_skip, downtime_skip)),
                   check('unispace5', merge(flaps(300, 900), ttl(620, 300), logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('mount')
    return result
