from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children, ttl, flaps, unreach_skip, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.checks.active.http import https_cert
from paysys.sre.tools.monitorings.lib.util.aggregators import downtime_skip, logic_or

host = "crm.stable.target"  # VIRT HOST
children = ['crm_prod_storage']  # CGROUP


def checks():

    result = merge(base.common_fin_fin(children),
                   services.nginx,
                   services.stunnel,
                   services.haproxy,
                   services.check_slb,
                   https_cert(name='https_certificate', port=443, warn=30, crit=14,
                              host='crm.yandex-team.ru', ssl_host='crm.yandex-team.ru'),
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    return result
