from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, gen_children, check, flaps
from paysys.sre.tools.monitorings.lib.util.aggregators import empty_kwargs, logic_and

host = "payments"
children = ['greed0Z.yandex.ru']

defaults = merge(
    ttl(86400, 90),
    {'namespace': 'psadmin.stable.dashboards'},
)

_checks = [
    'clearing_trust_oracle',
    'clearing_trust',
    'clearing_trust_xg',
    'trust_meta_queue.directory_notify.total.crit',
    'trust_meta_queue.directory_notify.total.errors',
    'trust_meta_queue.directory_notify.total.awaiting',
    'afs_reversal_rbs_webapi',
    'bs_export',
    'bs_missing_fiscals',
    'bs_missing_fiscals_oracle',
    'bs_payments_all_all_errors',
    'direct_fastpay',
    'drive_card_sber_rub',
    'hanging_payments',
    'oebs_export_registers',
    'pcidss_error',
    'processing_applestore',
    'processing_googleplay',
    'processing_webmoney',
    'processing_yamoney',
    'registries',
    's116_card',
    's118_apple_token',
    's118_direct_card',
    's118_yandex_money',
    's118_yandex_money_err',
    's120_cash',
    's124_card_err',
    's126_direct_card',
    's126_direct_card_err',
    's135_cash_err',
    's23_card',
    's23_trial_payment',
    's23_trial_payment_err',
    's7_card',
    's7_card_err',
    's7_yandex_money',
    's7_yandex_money_err',
    'simple_metamonitor1',
    'simple_metamonitor2',
    'subscriptions_bs',
    'taxi_card_yamoney_rub_pg',
    'taxifee_card_payture_amd_pg',
    'taxifee_card_rbs_rub_pg',
    'taxifee_card_sberbank_rub_pg',
    'tpay_missing_fiscals ',
    'monitorings.bindings.standard0',
    'monitorings.not_autorefunded_compensation'
]


def _make_check(service, _children):
    return check(service, gen_children(_children, service, 'HOST'), empty_kwargs, logic_and)


def checks():
    payments_checks = [_make_check(x, children) for x in _checks]
    payments_checks.append({"simple_metamonitor2": flaps(300, 1500)})
    return merge(*payments_checks)
