from paysys.sre.tools.monitorings.lib.checks.graphite import (
    graphite_check,
    graphite_get_all_metric,
)
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl

host = "paysys-dashboard.payments_conversion"
telegram = "Balance_payments_conversion_monitorings"
children = []

defaults = merge(ttl(620, 60), {"namespace": "psadmin.stable.dashboards"})


prefix_payments = (
    "one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.service_terminal_stat."
    "*.TRUST_PAYMENT.*.*.*.conversion_with_restriction"
)
MAJOR_SERVICES = [
    "s23",
    "s124",
    "s125",
    "s135",
    "s137",
    "s600",
    "s605",
    "s611",
    "s632",
    "s635",
]
TAXI_SERVICES = ["s124", "s125", "s135", "s137"]


def get_crit_and_warn_value(metric):
    name = metric[
        len(
            "one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.service_terminal_stat."
        ): -len(".success.conversion_with_restriction")
    ]
    crit_and_warn = config.get(name)
    if not crit_and_warn:
        crit_and_warn = config.get("default")
    return crit_and_warn


def get_payments_conversion(metric):
    name_part = metric.split(".")
    payment_type = name_part[5]
    service_id = name_part[6]
    name = "{}.{}.{}.{}.{}".format(
        name_part[3], name_part[4], payment_type, service_id, name_part[7]
    )
    refresh_time = 600  # seconds
    params = {"warn": 0.3, "crit": 0.05}
    if payment_type == "TRUST_PAYMENT" and service_id in MAJOR_SERVICES:
        params = get_crit_and_warn_value(metric)
        if service_id in TAXI_SERVICES:
            refresh_time = 120  # seconds
        else:
            refresh_time = 300  # seconds
    return graphite_check(name, metric, less=True, refresh_time=refresh_time, **params)


def checks():
    metrics = []
    for metric in graphite_get_all_metric(prefix_payments):
        metrics.append(get_payments_conversion(metric))
    return merge(*metrics)


config = {
    "default": {"crit": 0.2, "warn": 0.4},
    # TAXI
    # Payments
    "tpay_pg.TRUST_PAYMENT.s124.t66013002": {"crit": 0.3, "warn": 0.6},
    "tpay_pg.TRUST_PAYMENT.s124.t55713001": {"crit": 0.20, "warn": 0.5},
    "tpay_pg.TRUST_PAYMENT.s124.t55426001": {"crit": 0.25, "warn": 0.5},
    "tpay_pg.TRUST_PAYMENT.s124.t55422010": {"crit": 0.2, "warn": 0.4},
    "tpay_pg.TRUST_PAYMENT.s124.t55422006": {"crit": 0.15, "warn": 0.35},
    "tpay_pg.TRUST_PAYMENT.s124.t55422005": {"crit": 0.15, "warn": 0.3},
    "tpay_pg.TRUST_PAYMENT.s124.t55422001": {"crit": 0.2, "warn": 0.35},
    "tpay_pg.TRUST_PAYMENT.s124.t55413005": {"crit": 0.2, "warn": 0.35},
    "tpay_pg.TRUST_PAYMENT.s124.t55413002": {"crit": 0.15, "warn": 0.3},
    "tpay_pg.TRUST_PAYMENT.s124.55024001": {"crit": 0.2, "warn": 0.4},
    "tpay_pg.TRUST_PAYMENT.s124.t55013005": {"crit": 0.2, "warn": 0.35},
    "tpay_pg.TRUST_PAYMENT.s124.t213033": {"crit": 0.15, "warn": 0.35},
    # Link card
    "bs_oracle.TRUST_PAYMENT.s124.t55713001": {"crit": 0.3, "warn": 0.4},
    "bs_oracle.TRUST_PAYMENT.s124.t55422009": {"crit": 0.2, "warn": 0.3},
    "bs_oracle.TRUST_PAYMENT.s124.t55422006": {"crit": 0.2, "warn": 0.4},
    "bs_oracle.TRUST_PAYMENT.s124.t55422005": {"crit": 0.2, "warn": 0.4},
    "bs_oracle.TRUST_PAYMENT.s124.t55024001": {"crit": 0.15, "warn": 0.3},
    # UBER
    # Payments
    "tpay_pg.TRUST_PAYMENT.s125.t55713002": {"crit": 0.2, "warn": 0.4},
    "tpay_pg.TRUST_PAYMENT.s125.t55411502": {"crit": 0.15, "warn": 0.3},
    "tpay_pg.TRUST_PAYMENT.s125.t55411501": {"crit": 0.07, "warn": 0.15},
    "tpay_pg.TRUST_PAYMENT.s125.t55024003": {"crit": 0.2, "warn": 0.4},
    "tpay_pg.TRUST_PAYMENT.s125.t213033": {"crit": 0.15, "warn": 0.3},
    "tpay_pg.TRUST_PAYMENT.s125.t55013007": {"crit": 0.15, "warn": 0.35},
    # Link card
    "bs_oracle.TRUST_PAYMENT.s125.t55713002": {"crit": 0.15, "warn": 0.3},
    "bs_oracle.TRUST_PAYMENT.s125.t55411501": {"crit": 0.1, "warn": 0.25},
    "bs_oracle.TRUST_PAYMENT.s125.t55013007": {"crit": 0.15, "warn": 0.3},
    # TAXI_CORP
    # Payments. Service have not link cards.
    "tpay_pg.TRUST_PAYMENT.s135.t66001013": {"crit": 0.4, "warn": 0.6},
    "tpay_pg.TRUST_PAYMENT.s135.t66000004": {"crit": 0.4, "warn": 0.6},
    "tpay_pg.TRUST_PAYMENT.s135.t66000002": {"crit": 0.4, "warn": 0.6},
    # TAXI_DONATE
    # Payments. Service have not link cards.
    "bs_pg.TRUST_PAYMENT.s137.t66022017": {"crit": 0.4, "warn": 0.6},
    "bs_pg.TRUST_PAYMENT.s137.t66022015": {"crit": 0.4, "warn": 0.6},
    "bs_pg.TRUST_PAYMENT.s137.t66013006": {"crit": 0.4, "warn": 0.6},
    "bs_pg.TRUST_PAYMENT.s137.t66013005": {"crit": 0.4, "warn": 0.6},
    # UBER_ROAMING
    # Payments. Service has very few links_cards.
    "tpay_pg.TRUST_PAYMENT.s605.t55822001": {"crit": 0.15, "warn": 0.3},
    # Mediaservices
    # MUSIC
    # Payments
    "bs_pg.TRUST_PAYMENT.s23.t200037": {"crit": 0.07, "warn": 0.3},
    "bs_pg.TRUST_PAYMENT.s23.t55012105": {"crit": 0.01, "warn": 0.05},
    # EXTREMELY BAD CONVERSION
    "bs_pg.TRUST_PAYMENT.s635.t55009005": {"crit": 0.01, "warn": 0.2},
    # on eternal downtime
    # "bs_pg.TRUST_PAYMENT.s23.t55025002": {"crit": -0.01, "warn": -0.01},
    # "bs_pg.TRUST_PAYMENT.s23.t55025003": {"crit": -0.01, "warn": -0.01},
    # Link card
    "bs_oracle.TRUST_PAYMENT.s23.t200037": {"crit": 0.3, "warn": 0.4},
    # TICKETS
    "bs_oracle.TRUST_PAYMENT.s118.t55012102": {"crit": 0.15, "warn": 0.3},
    "bs_oracle.TRUST_PAYMENT.s118.t212107": {"crit": 0.17, "warn": 0.3},
    # EVENT_TICKETS
    "bs_oracle.TRUST_PAYMENT.s126.t212106": {"crit": 0.15, "warn": 0.3},
}
