from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check, movingMax, movingMin, movingAvg
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl


telegram = "Balance_spirit_monitorings"
host = "paysys-dashboard.spirit"

children = []

defaults = merge(
    ttl(620, 60),
    {'namespace': 'psadmin.stable.dashboards'},
)


ids = {
    'yandex': 7736207543,
    'buses': 7704402904,
    'taxi': 7704340310,
    'verticals': 7704340327,
    'market': 7704357909,
    'drive': 7704448440
}


def docs_by_min():
    prefix = "sumSeries(aliasByMetric(scale(groupByNodes(perSecond(" \
             "keepLastValue(removeBelowValue(one_min.whitespirit[1-9][a-z]_paysys_yandex_net.whitespirit.firm." \
             "{0}.device.*.documents.count, 1), 5)), 'sumSeries', 4), 60)))"
    # see https://grafana.yandex-team.ru/d/000012537/spirit?refresh=1m&panelId=3&fullscreen&edit&orgId=1&tab=metrics
    taxi = movingAvg(prefix.format(ids['taxi']), '7min')

    yandex = movingMax(prefix.format(ids['yandex']), '1h')
    market = movingMax(prefix.format(ids['market']), '8h')

    return [
        graphite_check('docs_per_minute_taxi', taxi, crit_expr='metric < 10 or metric > 5000'),
        graphite_check('docs_per_minute_yandex', yandex, crit_expr='not 1 < metric < 450'),
        graphite_check('docs_per_minute_market', market, crit_expr='not 1 <= metric < 140')
    ]


def timings():
    metric = "groupByNodes(one_min.whitespirit[1-9][a-z]_paysys_yandex_net" \
             ".whitespirit.call_stat.handler.make_receipt.error.*.number, 'sum', 7)"
    return graphite_check('response_timings', movingAvg(metric, '5min'), crit=14, warn=14)


def receipt_timings():
    metric = "aliasByNode(keepLastValue(one_min.whitespirit[1-9][a-z]_paysys_yandex_net.whitespirit" \
             ".call_stat.handler.make_receipt.success.1.percentile95, 2), 1)"
    return graphite_check('receipt_timings', movingMin(metric, '30min'), crit='0.9', warn='0.9')


def open_shifts():
    metric = "minSeries(groupByNodes(removeBelowValue(one_min.whitespirit[1-9][a-z]" \
             "_*.whitespirit.firm.{0}.*.device_state.OPEN_SHIFT, 1), 'sumSeries', 4, 1))"
    return [
        graphite_check('open_shifts_taxi', movingMax(metric.format(ids['taxi']), '5min'), crit=4, warn=4, less=True),
        graphite_check('open_shifts_yandex',
                       movingMax(metric.format(ids['yandex']), '10min'), crit=3, warn=3, less=True),
        graphite_check('open_shifts_buses', movingMax(metric.format(ids['buses']), '10min'), crit=2, warn=2, less=True),
        graphite_check('open_shifts_verticals',
                       movingMax(metric.format(ids['verticals']), '10min'), crit=2, warn=2, less=True),
        graphite_check('open_shifts_market', movingMax(metric.format(ids['market']), '10min'), crit=1, warn=1, less=True)
    ]


def ofd_queues():
    metric = "sumSeries(keepLastValue(one_min.whitespirit[1-9][a-z]_paysys_yandex_net." \
             "whitespirit.firm.*.device.*.ofd.*.queue_length, 1000)) "
    return graphite_check('ofd_queues', movingMin(metric, '2h'), crit=40, warn=40)


def free_space_fd():
    metric = "scale(one_min.whitespirit[1-9][a-z]_*" \
             ".whitespirit.firm.*.devices.fn_status.good, -1)"
    return graphite_check('free_space_fiscal_drive', movingAvg(metric, '5min'), crit=0, warn=0)


def documents_in_open_shift():
    metric = "maxSeries(one_min.whitespirit[1-9]" \
             "[a-z]_paysys_yandex_net.whitespirit.firm.*.device.*.shift.documents)"
    return graphite_check('documents_in_open_shift', movingAvg(metric, '5min'), crit=5275, warn=5275)


def checks():
    return merge(
        timings(),
        receipt_timings(),
        ofd_queues(),
        free_space_fd(),
        documents_in_open_shift(),
        *(docs_by_min() + open_shifts())
    )
