from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check_wildcard, graphite_check
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl

defaults = merge(
    ttl(620, 60),
    {'namespace': 'psadmin.stable.dashboards'},
)

host = "paysys-dashboard.taxi_antifraud"
telegram = "Balance_taxi_antifraud_monitorings"
children = []


def get_afs_status_checks(metric_name, name=None, alert_prc=1):
    name = name or metric_name
    metric_prefix = 'keepLastValue(one_min.greedaggrprod_yandex_ru.' \
        'simplebrother_balance_bo.trust_afs_data.{0}.per_5_min.{1}, 10)'
    status_list = ['error', 'exception', 'unknown']
    return merge(
        *[graphite_check(
            name + "_" + status,
            metric_prefix.format(metric_name, status),
            alert_prc,
            alert_prc,
            '-20min',) for status in status_list]
    )


def get_afs_actions_wildcard(name=""):
    metric = 'one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.trust_afs_data.payment_percent_per_afs_action{0}' \
             '.per_5_min.*.allow'
    check = 'payment_percent_per_afs_action{0}'
    return graphite_check_wildcard(
        check.format(name),
        metric.format(name),
        'aliasByNode(keepLastValue({0}, 10), 6, 7)',
        95,
        95,
        '-20min',
        less=True
    )


def checks():
    return merge(
        get_afs_actions_wildcard(),
        get_afs_actions_wildcard('_paystep'),
        get_afs_actions_wildcard('_pg'),
        get_afs_status_checks('payments_percent_per_afs_status'),
        get_afs_status_checks(
            'payments_percent_per_afs_status_paystep',
            alert_prc=2),
        get_afs_status_checks('payments_percent_per_afs_status_pg'),
    )
