from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check, movingMax, graphite_crit_on_zero
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl

defaults = merge(
    ttl(620, 60),
    {'namespace': 'psadmin.stable.dashboards'},
)

host = "paysys-dashboard.trust"
telegram = 'Balance_trust_monitorings'
children = []

# based on https://grafana.yandex-team.ru/d/000006866/balance-simple-1?refresh=1m&panelId=6&orgId=1

prefix = 'one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.{0}'
trust_prefix = 'one_min.greedaggrprod_yandex_ru.simplebrother_balance_bo.trust_payments.per_ten_min.{0}'


def taxi_payments_sberbank():
    return merge(
        graphite_check('taxi_payments_sberbank_crit', trust_prefix.format('crit__taxifee'), warn=10, crit=100),
        graphite_crit_on_zero('taxi_payments_sberbank_rub', prefix.format('taxifee_card_sberbank_rub')),
        graphite_crit_on_zero('taxi_payments_yamoney_rub', prefix.format('taxi_card_yamoney_rub')),
        graphite_crit_on_zero('taxi_payments_rbs_rub', prefix.format('taxifee_card_rbs_rub'))
    )


def taxi_payments_other():
    return merge(
        graphite_check('taxi_payments_other_crit', trust_prefix.format('crit__taxifee'), warn=10, crit=100),
        graphite_crit_on_zero('taxi_payments_other_apple_token',
                              trust_prefix.format('total_success_num__taxifee_apple_token')),
        graphite_crit_on_zero('taxi_payments_other_ecompay_eur', prefix.format('taxi_card_ecompay_eur'))
    )


def all_ticket_payments_alfabank_yandex_money():
    crit_metric = "sum({0})".format(trust_prefix.format("crit__{tickets,events_tickets}"))
    apple_token = "sum({0})".format(trust_prefix.format("total_success_num__{events_tickets,tickets}_apple_token"))

    return merge(
        graphite_check('ticket_payments_alfabank_yandex_money_crit', crit_metric, warn=10, crit=10),
        graphite_crit_on_zero('tickets_payments_apple_token', apple_token),
        graphite_crit_on_zero('tickets_payments_tickets_yamoney', prefix.format('tickets_card_yamoney_rub')),
        graphite_crit_on_zero('tickets_payments_tickets_alfabank', prefix.format('tickets_card_alfabank_rub')),
        graphite_crit_on_zero('events_tickets_payments_tickets_yamoney', prefix.format('events_tickets_card_yamoney_rub')),
        graphite_crit_on_zero('events_tickets_payments_tickets_alfabank', prefix.format('events_tickets_card_alfabank_rub')),
    )


def direct_payments_other():
    processing_prefix = prefix.format('processing.{0}')
    return merge(
        *[
            graphite_crit_on_zero(
                'direct_payments_other_{0}'.format(x),
                movingMax(processing_prefix.format(x), '10min')
            ) for x in ['rbsv2', 'trustweb']
        ]
    )


def direct_payments_yamoney():
    payments_prefix = prefix.format('paystep_payments_{0}')
    nodes = ['ya_all', 'ya_fast', 'ya_term']  # , 'ya_fp3']
    return merge(
        *[graphite_crit_on_zero(
            'direct_payments_yamoney_{0}'.format(x),
            payments_prefix.format(x)
        ) for x in nodes]
    )


def direct_ppc_cummulative():
    return merge(
        graphite_check('direct_pcc_CRIT', trust_prefix.format('crit__PPC'), crit=0.0, warn=0.0),
        graphite_crit_on_zero('direct_ppc_success_card', trust_prefix.format('total_success_num__PPC_card)'))
    )


def music_payments():
    return merge(
        graphite_crit_on_zero('music_payments_credit_card', prefix.format('music_success')),
        graphite_crit_on_zero('music_payments_apple', prefix.format('music.apple')),
        graphite_crit_on_zero('music_payments_google', prefix.format('music.google'))
    )


def disk_store_buses_all_of_market():
    return graphite_crit_on_zero('yandex_disk_payments', prefix.format('disc_success'))


def drive():
    return merge(
        graphite_crit_on_zero('drive_payments_card_sber', prefix.format('drive_card_sber_rub')),
        graphite_check('drive_payments_crit', movingMax(trust_prefix.format('crit__carsharing'), '10min'), crit=10)
    )


def checks():
    return merge(
        taxi_payments_sberbank(),
        taxi_payments_other(),
        all_ticket_payments_alfabank_yandex_money(),
        direct_payments_other(),
        direct_payments_yamoney(),
        direct_ppc_cummulative(),
        music_payments(),
        disk_store_buses_all_of_market(),
        drive()
    )
