from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.checks.base import merge, check, unreachable
from paysys.sre.tools.monitorings.lib.util.helpers import gen_children_deploy
from paysys.sre.tools.monitorings.lib.checks.services import pushclient_check
from paysys.sre.tools.monitorings.lib.checks.active.http import http


def checks(
    children_app,
    children_celery,
    balancers
):
    return merge(
        l7_monitoring(balancers),
        pushclient_check,
        unreachable,
        http('app', 8080, ok_codes=[200, 301, 302], crit=0, headers={'Host': 'localhost'}),
        check('app', gen_children_deploy(children_app, 'app')),
        *[
            check(x, gen_children_deploy(children_app + children_celery, x))
            for x in [
                'UNREACHABLE',
                'pushclient_check',
            ]
        ]
    )


def l7_balancer(fqdn, dcs):
    return [
        {
            'namespace': fqdn,
            'datacenters': dcs,
            'host': fqdn,
            'http_ports': [80],
            'https_ports': [443],
            'services': [
                'rtc_balancer_{0}_{1}'.format(fqdn.replace('.', '_'), dc) for dc in dcs
            ],
            'checks': {
                'cpu_usage': {'warn': 60, 'crit': 80},
                'cpu_wait': {'warn': 0.5, 'crit': 1},
                'codes_5xx': {'warn': 0.5, 'crit': 1},
                'attempts_backend_errors': {'warn': 1, 'crit': 2},
            },
        },
    ]
