from paysys.sre.tools.monitorings.configs.dcsaap.base import dcsaap
from paysys.sre.tools.monitorings.lib.checks.postgres import postgres
from paysys.sre.tools.monitorings.lib.notifications import Notifications, \
    FIN_TOOLS_ESCALATION_USERS, FIN_TOOLS_TELEGRAM_GROUP
from paysys.sre.tools.monitorings.lib.util.helpers import merge, empty_children

host = 'dcsaap.production'
children = empty_children
children_app = ['billing-dcs@stage=billing-dcs-prod-stage;deploy_unit=app']
children_celery = ['billing-dcs@stage=billing-dcs-prod-stage;deploy_unit=celery']
fqdn = 'dcs-prod-l7.paysys.yandex.net'

defaults = {'namespace': 'dcsaap.stable'}

notifications = Notifications() \
    .set_iron_woman(delay=1200, logins=FIN_TOOLS_ESCALATION_USERS) \
    .set_telegram(FIN_TOOLS_TELEGRAM_GROUP)


def checks():
    return merge(
        dcsaap.checks(
            children_app,
            children_celery,
            dcsaap.l7_balancer(fqdn, ['man', 'sas', 'vla'])
        ),
        postgres("mdbe1pf6lkuo4a3n70tm", "balance_dcs", query_time_limit=40, alive_hosts=True)
    )
