from paysys.sre.tools.monitorings.lib.checks.base import common, syslog_alive
from paysys.sre.tools.monitorings.lib.checks.services import haproxy
from paysys.sre.tools.monitorings.lib.util.aggregators import empty_kwargs
from paysys.sre.tools.monitorings.lib.util.helpers import flaps, merge, ttl, gen_unreach


EXCLUDED_CHECKS_TEST = [
    "bmc",
    "clock",
    "cpu",
    "disk",
    "ecc",
    "gpu",
    "hbf_service_last_update_status",
    "hbf_service_status",
    "iptruler",
    "link",
    "mem",
    "paysys_archiver",
    "push-client",
    "skynet",
]
EXCLUDED_CHECKS_STABLE = EXCLUDED_CHECKS_TEST + [
    "UNREACHABLE",
]


def filter_checks(checks, exclude):
    for check_name in exclude:
        checks.pop(check_name)
    return checks


def get_checks(children, exclude=[]):
    checks = merge(
        common(children),
        syslog_alive,
        merge(haproxy, {"haproxy": ttl(120, 30)}),
        {"push-client": merge(flaps(900, 3600), ttl(3780, 300))},
    )
    return filter_checks(checks, exclude)


def update_unreach(checks, unreach_service):
    unreach = gen_unreach([unreach_service])
    for check_name, check_kwargs in checks.items():
        if check_kwargs.get("active") == "graphite":
            continue

        args = empty_kwargs
        if check_name != unreach_service:
            aggregator_kwargs = check_kwargs.get("aggregator_kwargs", {})
            aggregator_kwargs.update(unreach["aggregator_kwargs"])
            args = {"aggregator_kwargs": aggregator_kwargs}
        check_kwargs.update(args)

    return checks
