from paysys.sre.tools.monitorings.configs.diehard.base import common
from paysys.sre.tools.monitorings.lib.checks import services
from paysys.sre.tools.monitorings.lib.checks.active import tcp_chat, icmpping
from paysys.sre.tools.monitorings.lib.checks.active.http import https_cert
from paysys.sre.tools.monitorings.lib.util.aggregators import empty_kwargs
from paysys.sre.tools.monitorings.lib.util.helpers import (
    flaps,
    merge,
    gen_children_from_tuples,
)


def get_checks(children, exclude_common):
    return merge(
        common.get_checks(children, exclude_common),
        services.nginx_alive,
        services.squid,
    )


def cert(name, host, port=443):
    return merge(
        https_cert(name, port=port),
        {name: empty_kwargs},
        {name: gen_children_from_tuples([(host, name, "HOST")])},
    )


def tcp(name, host, port, is_ipv6=True, flaps_stable_time=20, flaps_critical_time=120):
    return merge(
        tcp_chat(
            name,
            port=port,
            timeout=2,
            refresh_time=5,
            use_all_dc=True,
            disable_ipv6=(not is_ipv6),
            disable_ipv4=is_ipv6,
            aggr_mode="worst",
        ),
        {name: empty_kwargs},
        {name: gen_children_from_tuples([(host, name, "HOST")])},
        {name: flaps(flaps_stable_time, flaps_critical_time)},
    )


def icmp(name, host):
    return merge(
        icmpping(name, refresh_time=5, use_all_dc=True),
        {name: empty_kwargs},
        {name: gen_children_from_tuples([(host, name, "HOST")])},
    )
