from paysys.sre.tools.monitorings.lib.checks.active.http import https_cert
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.util.aggregators import empty_kwargs
from paysys.sre.tools.monitorings.lib.util.helpers import (
    merge,
    gen_children_from_tuples,
    gen_children_deploy,
    make_aggregated_check,
    check,
)


def l3(service, geos=[]):
    children = []
    for geo in geos:
        children.append({'service': service, 'host': geo})
    hosts = [(geo, service, 'HOST') for geo in geos]
    result = check('L3', gen_children_from_tuples(hosts), empty_kwargs)
    return result


def cert(name, host, port=443):
    return merge(
        https_cert(name, port=port),
        {name: empty_kwargs},
        {name: gen_children_from_tuples([(host, name, 'HOST')])},
    )


def get_checks(children):
    return merge(
        make_aggregated_check(check=unreachable, percent=40),
        check('UNREACHABLE', gen_children_deploy(children, 'UNREACHABLE')),
    )
