from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl
from paysys.sre.tools.monitorings.configs.diehard.base import notifications_object

defaults = merge(
    {"namespace": "diehard.stable"},
    ttl(620, 60),
)

notifications = {
    "default": notifications_object.iron_woman_and_telegram,
    "by_service": {
        # telegram
        "hwerrors2": notifications_object.telegram,
        "salt-minion": notifications_object.telegram,
        # sms_abc_and_telegram
        "check-certs": notifications_object.sms_abc_and_telegram,
        "crt_duckgo.trust.yandex.net": notifications_object.sms_abc_and_telegram,
        "crt_pcidss.yandex.net": notifications_object.sms_abc_and_telegram,
        "mysql-metric_Com_delete": notifications_object.sms_abc_and_telegram,
        "mysql-metric_Com_insert": notifications_object.sms_abc_and_telegram,
        "mysql-metric_Com_select": notifications_object.sms_abc_and_telegram,
        "mysql-metric_Com_update": notifications_object.sms_abc_and_telegram,
        "mysqldump": notifications_object.sms_abc_and_telegram,
        # iron_woman_and_sms_abc_and_telegram
        "cpu_usage": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "mem-free": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "mysql-connections-free": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "named-alive": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "nginx-alive": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "splunkforwarder": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "squid-alive": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "syslog-alive": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "yandex-duckgo": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "yandex-passport-tvmtool": notifications_object.iron_woman_and_sms_abc_and_telegram,
        # iron_woman_daytime_and_sms_abc_and_telegram
        "unispace": notifications_object.iron_woman_daytime_and_sms_abc_and_telegram,
        # no notifications
        "watchdog": {},
        "mastercard-keys": notifications_object.sms_abc_and_telegram,
        "yandex-duckgo-secrets": notifications_object.sms_abc_and_telegram,
    },
    "by_host": {
        "diehard.scan": notifications_object.telegram,
        "diehard.outbproxy": notifications_object.telegram,
        "diehard.L7": notifications_object.telegram,
    },
}

CONFIGS = [
    "back",
    "backup",
    "bckp",
    "db_kvm",
    "duckgo_front",
    "front",
    "galera",
    "mgmt",
    "proxy",
    "scan",
    "virt",
    "L7",
    "outbproxy"
]
