from paysys.sre.tools.monitorings.configs.diehard.base import back, common
from paysys.sre.tools.monitorings.lib.checks.base import iptables
from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import (
    nginx_elasticsearch_bundle,
)
from paysys.sre.tools.monitorings.lib.util.helpers import flaps, merge

host = "diehard.back"
children = ["pcidss-back"]


graphite_nginx_metric_prefix = (
    "paysys.prod.combaine.backup1w_paysys_yandex_net.pcidss-nginx.pcidss_back"
)


def nginx_combaine_5xx(name, action, crit=0.2, warn=0.2):
    return graphite_check(
        name,
        metric="{}.{}.errors".format(graphite_nginx_metric_prefix, action),
        url="https://gr-mg.yandex-team.ru",
        warn=warn,
        crit=crit,
        window="-5min",
        null_status="OK",
    )


def nginx_combaine_499(name, action, crit=0.2, warn=0.2):
    return graphite_check(
        name,
        metric="{}.{}.client_closed".format(graphite_nginx_metric_prefix, action),
        url="https://gr-mg.yandex-team.ru",
        warn=warn,
        crit=crit,
        window="-5min",
        null_status="OK",
    )


def checks():
    base_checks = common.update_unreach(
        merge(
            back.get_checks(children, common.EXCLUDED_CHECKS_STABLE),
            iptables,
            back.nginx_status("active_connections", children, warn=25, crit=10, less=True),
        ),
        unreach_service="daytime",
    )
    return merge(
        base_checks,
        nginx_elasticsearch_bundle(
            conductor_children=children,
            crit_errors_by_host=40.0,
            warn_errors_by_host=20.0,
            elasticsearch_agg="pcidss-back-ps",
            disable_499_checks=True,
        ),
        {"nginx_errors": flaps(900, 3600)},
        nginx_combaine_5xx("nginx_key_keeper2-read_5xx", "key_keeper2-read"),
        nginx_combaine_499("nginx_key_keeper2-read_499", "key_keeper2-read"),
        nginx_combaine_5xx("nginx_ping_or_status_5xx", "ping_or_status"),
        nginx_combaine_499("nginx_ping_or_status_499", "ping_or_status"),
        {"nginx_ping_or_status_499": flaps(120, 600)},
    )
