from paysys.sre.tools.monitorings.configs.diehard.base import common
from paysys.sre.tools.monitorings.lib.checks.base import disk_ssd, kvm, cpu_usage
from paysys.sre.tools.monitorings.lib.util.helpers import flaps, merge

host = "diehard.db-kvm"
children = ["pcidss-db-kvm"]


def checks():
    flaps_stable, flaps_critical = 180, 600
    result = merge(
        common.get_checks(children, common.EXCLUDED_CHECKS_STABLE),
        disk_ssd(children, wait_warn=200, wait_crit=250, util_warn=25, util_crit=40),
        {"disk-wait": flaps(flaps_stable, flaps_critical)},
        cpu_usage(children),
        kvm,
    )

    try:
        for _, child_cfg in result['disk-wait']['subchecks'].items():
            child_cfg['disk-wait']['flaps_config'].critical = flaps_critical
            child_cfg['disk-wait']['flaps_config'].stable = flaps_stable
    except KeyError:
        pass

    return common.update_unreach(result, "daytime")
