from paysys.sre.tools.monitorings.configs.diehard.base import common, front
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "diehard.duckgo-front"
children = ["pcidss-duckgo-front"]


def checks():
    base_checks = common.update_unreach(
        front.get_checks(children, common.EXCLUDED_CHECKS_STABLE),
        unreach_service="daytime",
    )
    return merge(
        base_checks,
        front.cert("crt_duckgo.trust.yandex.net", "duckgo.trust.yandex.net", 2443),
        front.tcp(
            "tcp4_duckgo.trust.yandex.net", "duckgo.trust.yandex.net", 2443, False
        ),
        front.tcp(
            "tcp6_duckgo.trust.yandex.net", "duckgo.trust.yandex.net", 2443, True
        ),
        front.icmp("icmp_duckgo.trust.yandex.net", "duckgo.trust.yandex.net"),
    )
