from paysys.sre.tools.monitorings.configs.diehard.base import common, front
from paysys.sre.tools.monitorings.lib.util.helpers import flaps, merge
from paysys.sre.tools.monitorings.lib.checks import nginx_bundles as nginx

host = "diehard.front"
children = ["pcidss-front"]


def checks():
    base_checks = common.update_unreach(
        front.get_checks(children, common.EXCLUDED_CHECKS_STABLE),
        unreach_service="daytime",
    )
    return merge(
        base_checks,
        front.cert("crt_pcidss.yandex.net", "pcidss.yandex.net"),
        front.tcp("tcp4_pcidss.yandex.net", "pcidss.yandex.net", 443, False),
        front.tcp("tcp6_pcidss.yandex.net", "pcidss.yandex.net", 443, True),
        front.icmp("icmp_pcidss.yandex.net", "pcidss.yandex.net"),
        nginx.nginx_elasticsearch_bundle(
            conductor_children=children,
            crit_errors_by_host=85.0,
            warn_errors_by_host=50.0,
            elasticsearch_agg="pcidss-front-ps",
            disable_499_checks=True,
        ),
        {"nginx_errors": flaps(900, 3600)},
    )
