from paysys.sre.tools.monitorings.configs.diehard.base import common, galera
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "diehard.galera"
children = ["pcidss-db"]


def checks():
    result = merge(
        galera.get_checks(children, common.EXCLUDED_CHECKS_STABLE),
        galera.mysql_status("Com_select", children, warn=800, crit=1000),
        galera.mysql_status("Com_insert", children),
        galera.mysql_status("Com_update", children),
        galera.mysql_status("Com_delete", children),
        galera.mysql_free_connections(children),
    )
    return common.update_unreach(result, "daytime")
