from paysys.sre.tools.monitorings.configs.diehard.base import common, proxy
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import (
    nginx_elasticsearch_bundle,
)
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "diehard.proxy"
children = ["pcidss-proxy"]


def checks():
    result = merge(
        proxy.get_checks(children, common.EXCLUDED_CHECKS_STABLE),
        nginx_elasticsearch_bundle(
            conductor_children=children, elasticsearch_agg="pcidss-proxy"
        ),
        {"pcidss-log-handler": {}},
        {"pcidss-log-sender": {}},
    )
    return common.update_unreach(result, "daytime")
