from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.checks.active.http import https_cert
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children, unreach_force_ok, gen_children_from_tuples, flaps, ttl, gen_unreach_by_service, unreach_skip
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, downtime_skip

host = "dist.stable"  # VIRT HOST
children = ['rhel-dist']  # CGROUP


def checks():
    result = merge(
        base.common_fin_fin(children),
        {'UNREACHABLE': gen_children_from_tuples([('rhel-dist', 'UNREACHABLE', 'CGROUP'), ('r7x86-64.oebs.yandex.net', 'UNREACHABLE', 'HOST')])},
        merge(check('epel-syncer', merge(gen_children(['r7x86-64.oebs.yandex.net'], 'epel-syncer', 'HOST')), unreach_force_ok)),
        services.gluster_health,
        services.check_slb,
        services.nginx,
        https_cert(name='https_certificate', port=443, warn=30, crit=14,
                   host='paysys-rhel.dist.yandex.net', ssl_host='paysys-rhel.dist.yandex.net'),
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children_from_tuples([('rhel-dist', 'uptime', 'CGROUP'), ('r7x86-64.oebs.yandex.net', 'uptime', 'HOST')]),
                              logic_or, unreach_skip, downtime_skip)),
    )
    result = gen_unreach_by_service(result)
    return result
