from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, flaps, gen_children
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.checks.active.http import https


def get_checks(children):
    checks = merge(
        base.common_fin_fin(children),
        services.check_slb,
        services.haproxy,
        services.jmx2graphite,
        services.keepalived,
        services.ldap,
        services.mailq,
        services.nginx,
        services.stunnel,
        {'hyp_rsync': ttl(1200, 300)},
        {'hyp_home_size': merge(ttl(7200, 1800), flaps(7200, 0))},
        {'sendmail': merge(ttl(1800, 1200), flaps(1800, 0))},
        check('weblogic_overall_health_state', ttl(600, 300), flaps(600, 0), gen_children(
            children, 'overall_health_state')),
        check('weblogic_health', ttl(600, 300), flaps(600, 0), gen_children(
            children, [
                'failed_servers',
                'nodemanager_state'
            ])),
        check('weblogic_oom', ttl(600, 300), flaps(600, 0), gen_children(
            children, [
                'jvm_oom_dumps',
                'oom_in_logs'
            ])),
        check('hyp-health', ttl(600, 300), flaps(900, 0), gen_children(
            children, [
                'hyp-alive',
                'http_get'
            ])),
        https('hyp_workspace', path='/workspace/logon/ping'),
        check('tvm_health', ttl(600, 300), gen_children(
            children, [
                'tvm_ping'
            ]
        )),
    )

    checks.pop('ldap-limits')

    return checks
