from paysys.sre.tools.monitorings.lib.util.helpers import merge, check
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import downtime_force_ok


# Do not need to repeat checks from appl because appl and db are on the same host now
def get_checks(children):
    checks = merge(
        services.audit,
        services.oracle_database,
        services.oracle_rac,
        base.unreachable,
        check('shared_pool_free_mem', downtime_force_ok),
        check('audit-splunk', downtime_force_ok)
    )

    checks.pop('fk-indexing')
    checks.pop('matview-monitor')
    checks.pop('matview-refresh')
    checks.pop('mvlogmove')
    checks.pop('ro-services')

    return checks
