from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, flaps, gen_children
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and


def get_checks(children):
    checks = merge(
        base.common_fin_fin(children),
        services.ldap,
        services.mailq,
        services.nginx,
        services.stunnel,
        {'integration': ttl(1800, 900)},
        {'mdx': merge(ttl(600, 300), flaps(900, 0))},
        {'sendmail': merge(ttl(1800, 1200), flaps(1800, 5400))},
        check('ess-health', ttl(600, 300), flaps(900, 0), gen_children(children, 'hyp-alive'), logic_and)
    )

    checks.pop('ldap-limits')

    return checks
