from paysys.sre.tools.monitorings.configs.hyperion.base import appl

from paysys.sre.tools.monitorings.lib.checks.active.http import https_cert
from paysys.sre.tools.monitorings.lib.util.aggregators import downtime_force_ok, logic_or, downtime_skip
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, gen_children, check, unreach_skip, flaps, gen_unreach_by_service


host = "hyperion.stable.appl"
children = ['hyp_apps']


def checks():
    locks_children = gen_children(
        'paysys_backup_sox', [
            'failed_locks_hyp-prod',
            'staled_clients_hyp-prod',
            'staled_locks_hyp-prod',
            'unfetched_locks_hyp-prod',
        ])

    checks = merge(
        appl.get_checks(children),
        https_cert('slb_https_cert', host='hyp.yandex-team.ru', ssl_host='hyp.yandex-team.ru'),
        check('backup', ttl(3700, 300), gen_children(children, 'hyp_backup')),
        check('locks_health', merge(ttl(700, 350), locks_children, logic_or, unreach_skip, downtime_force_ok)),
        {'UNREACHABLE': gen_children(['paysys_backup_sox', 'hyp_apps'], 'UNREACHABLE')},
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_force_ok)),
        check('unispace5', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'unispace5'),
                                 logic_or, unreach_skip, downtime_skip)),
    )

    checks = gen_unreach_by_service(checks)
    return checks
