from paysys.sre.tools.monitorings.configs.hyperion.base import db

from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check
from paysys.sre.tools.monitorings.lib.util.aggregators import downtime_force_ok, logic_or, logic_and, downtime_skip
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, gen_children, check, unreach_skip, flaps, gen_unreach_by_service

host = "hyperion.stable.db"
children = ['hyp_apps']


def checks():
    first_nodes_children = gen_children(
        [
            'hyp-apps1e.yandex.ru',
            'hyp-apps1f.yandex.ru',
            'hyp-apps1v.oebs.yandex.net'
        ],
        'oracle-status-hyp1', 'HOST'
    )

    checks = merge(
        db.get_checks(children),
        check('oracle-status-hyp1', merge(first_nodes_children, logic_and)),
        graphite_check('diskstat_wait_iva', 'movingAverage(averageSeries(one_min.{hyp-apps1e_yandex_ru,hyp-ess2e_yandex_ru}.diskstat_wait*.wait),50)', window='-60min', crit_expr='metric > 300'),  # noqa
        graphite_check('diskstat_wait_myt', 'movingAverage(averageSeries(one_min.{hyp-apps1f_yandex_ru,hyp-ess2f_yandex_ru}.diskstat_wait*.wait),50)', window='-60min', crit_expr='metric > 300'),  # noqa
        graphite_check('diskstat_wait_vla', 'movingAverage(averageSeries(one_min.{hyp-apps1v_oebs_yandex_net,hyp-ess2v_oebs_yandex_net}.diskstat_wait*.wait),50)', window='-60min', crit_expr='metric > 300'),  # noqa
        graphite_check('number_of_degraded_disks_iva', 'countSeries(maximumAbove(one_min.hyp-apps1e_yandex_ru.diskstat_wait_*.wait,300))', window='-5min', crit_expr='metric > 0', null_status='OK'),  # noqa
        graphite_check('number_of_degraded_disks_myt', 'countSeries(maximumAbove(one_min.hyp-apps1f_yandex_ru.diskstat_wait_*.wait,300))', window='-5min', crit_expr='metric > 0', null_status='OK'),  # noqa
        graphite_check('number_of_degraded_disks_vla', 'countSeries(maximumAbove(one_min.hyp-apps1v_oebs_yandex_net.diskstat_wait_*.wait,300))', window='-5min', crit_expr='metric > 0', null_status='OK'),  # noqa
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_force_ok)),
        check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                               logic_or, unreach_skip, downtime_force_ok)),
        check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                   logic_or, unreach_skip, downtime_force_ok)),
        check('s3backup-hyp', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
    )

    checks.pop('oracle-status')

    checks = gen_unreach_by_service(checks)
    return checks
