from paysys.sre.tools.monitorings.configs.hyperion.base import ess

from paysys.sre.tools.monitorings.lib.checks.active.http import https_cert
from paysys.sre.tools.monitorings.lib.util.aggregators import downtime_force_ok, logic_or, downtime_skip
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, gen_children, check, unreach_skip, flaps, gen_unreach_by_service


host = "hyperion.stable.ess"
children = ['hyp_ess']


def checks():
    checks = merge(
        ess.get_checks(children),
        check('backup', ttl(900, 300), flaps(600, 0), gen_children(children, ['essbase_backup', 'weekly_backups'])),
        https_cert('ess_https_cert_iva', host='hyp-ess2e.yandex.ru', ssl_host='hyp-ess2e.yandex.ru', port=8080),
        https_cert('ess_https_cert_myt', host='hyp-ess2f.yandex.ru', ssl_host='hyp-ess2f.yandex.ru', port=8080),
        https_cert('ess_https_cert_vla', host='hyp-ess2v.oebs.yandex.net', ssl_host='hyp-ess2v.oebs.yandex.net', port=8080),
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_force_ok)),
        check('unispace5', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'unispace5'),
                                 logic_or, unreach_skip, downtime_skip)),
    )

    checks = gen_unreach_by_service(checks)
    return checks
