from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_skip, flaps, gen_children, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip, logic_or
from paysys.sre.tools.monitorings.configs.balance.base import database


host = "market.mdbaas.db"  # VIRT HOST
children = ['ps-mdbaas-rdbms-vla', 'ps-mdbaas-rdbms-sas']  # CGROUP

exclude_db_checks = [
    'oracle-status', 'shared_pool_free_mem', 'mvlogmove', 'psdbstat', 'ps_ts_info', 'ps_segment_info',
    'user-objects-in-sys', 'db-file_locations', 'db-parameters', 'oracle_memory_usage',
    'matview-refresh', 'matview-monitor', 'fk-indexing'
]

exclude_rac_checks = ['oracle-patches']

database_global = services.oracle_database.copy()
database_project = database.get_checks(children)

database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]

rac_result = services.oracle_rac.copy()
[rac_result.pop(exclude) for exclude in exclude_rac_checks]


def checks():
    result = merge(base.common_fin_fin(children),
                   rac_result,
                   database_result,
                   check('oracle-status-billcdbdev_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-scatcdbdev_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-scatcdbmt_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mhypcdbdev_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-billcdbtst_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-scatcdbtst_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mhypcdbcpy_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mhypcdbtst_1', merge(ttl(180, 60), logic_and, unreach_skip, downtime_skip)),
                   services.pipeline_sender,
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('link_utilization')
    result.pop('mount')
    return result
