from paysys.sre.tools.monitorings.lib.checks import base
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps, check, unreach_skip, gen_children, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip

host = "market.mdbaas.target"  # VIRT HOST
children = ['ps-mdbaas-target-vla', 'ps-mdbaas-target-sas']  # CGROUP


def checks():
    result = merge(base.common_fin_fin(children),
                   check('check-scst-portals', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('iscsi-scstd-alive', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('link_utilization')
    result.pop('mount')
    return result
