from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, flaps, gen_unreach_by_service, unreach_skip, gen_children
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip

host = "billing.stable.db"  # VIRT HOST
children = ['cs_oracledb-billing']  # CGROUP

exclude_db_checks = ['oracle-status', 'shared_pool_free_mem']

exclude_rac_checks = ['iscsi-params', 'oracle-patches']

database_global = services.oracle_database.copy()

database_result = merge(database_global)
[database_result.pop(exclude) for exclude in exclude_db_checks]

rac_result = services.oracle_rac.copy()
[rac_result.pop(exclude) for exclude in exclude_rac_checks]


def checks():
    result = merge(base.common_fin_fin(children),
                   rac_result,
                   database_result,
                   check('oracle-status-billingcdb1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('password-expire-billingcdb1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('seq-check', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   services.mailq,
                   services.pipeline_sender,
                   services.audit,
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   check('oracle-balance-patches', merge(ttl(5400, 3600), logic_or, unreach_skip, downtime_skip)),
                   check('unispace5', merge(flaps(300, 900), ttl(620, 300), logic_or, unreach_skip, downtime_skip)),
                   check('s3backup-billingutf', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
                   )
    result = gen_unreach_by_service(result)
    result.pop('mount')
    return result
