from paysys.sre.tools.monitorings.configs.mdh.common import ProjectConfig, Component


class MdhConfig(ProjectConfig):

    project = 'mdh'

    components = [
        Component(
            alias='backend',
            fqdn='api.{prj[-env]}.{dom_yteam}',
            balancer_service='rtc_balancer_api_{prj[-env]}_{path_paysys}',
            deploy_group='balance-{deploy_group}',
        ),
        Component(
            alias='frontend',
            balancer_service='rtc_balancer_{prj[-env]}_{path_paysys}',
            deploy_group='balance-{deploy_group}',
            port=8080,
        ),
    ]
