from paysys.sre.tools.monitorings.lib.notifications import Notifications, BALANCE_ESCALATION_USERS, FIN_TOOLS_ESCALATION_USERS, FIN_TOOLS_TELEGRAM_GROUP

calendar_id = 38178

notifications_object_prod = Notifications()
notifications_object_prod.set_calendar(calendar_id)
notifications_object_prod.set_iron_woman(logins=BALANCE_ESCALATION_USERS)
notifications_object_prod.set_startrek('PAYSYSDBA', status='CRIT', components='monitoring', priority='normal')
notifications_object_prod.set_telegram('yndx-meta-duty-monitoring')


notifications_object_developers = Notifications()
notifications_object_developers.set_calendar(calendar_id)
notifications_object_developers.set_startrek('BALANCEDUTY', status='CRIT', components='monitoring', priority='critical')
notifications_object_developers.set_iron_woman(logins=FIN_TOOLS_ESCALATION_USERS)
notifications_object_developers.set_telegram(FIN_TOOLS_TELEGRAM_GROUP)
# notifications_object_developers = notifications_object_prod

notifications_stable = {
    # ST+TG
    'default': notifications_object_prod.startrek_and_telegram_critonly,
    'by_service': {
        # 24CALL+TG+ST
        'asm-status-ng': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'database-up': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'grid-up': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'UNREACHABLE': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'uptime': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'oracle-status-meta1': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'oracle-status-meta2': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'oracle-status-scat1': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'oracle-status-scat2': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'oracle-status-mhypcdb1': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'oracle-status-mhypcdb2': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'load_average_paysys': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,
        'unispace5': notifications_object_prod.iron_woman_and_startrek_and_telegram_critonly,

        # DAY_CALL+TG
        'farsync-state': notifications_object_prod.iron_woman_daytime_and_telegram,
        'host_memory_usage': notifications_object_prod.iron_woman_daytime_and_telegram,
        'net_services': notifications_object_prod.iron_woman_daytime_and_telegram,

        # TG
        'bora-configs': notifications_object_prod.telegram_critonly,
        'check-scst-portals': notifications_object_prod.telegram_critonly,
        'configs': notifications_object_prod.telegram_critonly,
        'crs-autostart': notifications_object_prod.telegram_critonly,
        'daytime': notifications_object_prod.telegram_critonly,
        'db-file_locations-meta': notifications_object_prod.telegram_critonly,
        'db-file_locations-mhyp': notifications_object_prod.telegram_critonly,
        'db-file_locations-pcrm': notifications_object_prod.telegram_critonly,
        'db-file_locations-scatnew': notifications_object_prod.telegram_critonly,
        'grub': notifications_object_prod.telegram_critonly,
        'hbf_service_last_update_status': notifications_object_prod.telegram_critonly,
        'hbf_service_status': notifications_object_prod.telegram_critonly,
        'hugepages': notifications_object_prod.telegram_critonly,
        'iscsi-ips': notifications_object_prod.telegram_critonly,
        'iscsi-params': notifications_object_prod.telegram_critonly,
        'iscsi-scstd-alive': notifications_object_prod.telegram_critonly,
        'link_utilization': notifications_object_prod.telegram_critonly,
        'mail_queue': notifications_object_prod.telegram_critonly,
        'netconsole': notifications_object_prod.telegram_critonly,
        'ntp-stratum': notifications_object_prod.telegram_critonly,
        'oracleasm_iid_cnt': notifications_object_prod.telegram_critonly,
        'oracle-balance-patches': notifications_object_prod.telegram_critonly,
        'oracle_memory_usage': notifications_object_prod.telegram_critonly,
        'paysys-common-settings': notifications_object_prod.telegram_critonly,
        'psdbstat': notifications_object_prod.telegram_critonly,
        'ps_segment_info': notifications_object_prod.telegram_critonly,
        'ps_ts_info': notifications_object_prod.telegram_critonly,
        'raid': notifications_object_prod.telegram_critonly,
        'raid_check_speed': notifications_object_prod.telegram_critonly,
        'rm-logs': notifications_object_prod.telegram_critonly,
        'rm-logs-meta': notifications_object_prod.telegram_critonly,
        'rm-logs-scatnew': notifications_object_prod.telegram_critonly,
        'rm-logs-pcrm': notifications_object_prod.telegram_critonly,
        'rm-logs-mhyp': notifications_object_prod.telegram_critonly,
        'rm-traces': notifications_object_prod.telegram_critonly,
        'ro-services': notifications_object_prod.telegram_critonly,
        'standby-lag': notifications_object_prod.telegram_critonly,
        'sysctl': notifications_object_prod.telegram_critonly,
        'unbound': notifications_object_prod.telegram_critonly,
        'user-objects-in-sys-meta': notifications_object_prod.telegram_critonly,
        'watchdog': notifications_object_prod.telegram_critonly,
        'fk-indexing-scat': notifications_object_prod.telegram_critonly,
        'matview-monitor-scat': notifications_object_prod.telegram_critonly,
        'matview-refresh-scat': notifications_object_prod.telegram_critonly,
        'matview-refresh-scatnew1': notifications_object_prod.telegram_critonly,
        'seq-check-scat': notifications_object_prod.telegram_critonly,
        'user-objects-in-sys-scat': notifications_object_prod.telegram_critonly,
        'matview-monitor-mhypcdb1': notifications_object_prod.telegram_critonly,
        'matview-refresh-mhypcdb1': notifications_object_prod.telegram_critonly,
        'seq-check-mhypcdb1': notifications_object_prod.telegram_critonly,
        'user-objects-in-sys-mhypcdb1': notifications_object_prod.telegram_critonly,
        'fk-indexing-pcrm': notifications_object_prod.telegram_critonly,
        'matview-monitor-pcrm': notifications_object_prod.telegram_critonly,
        'matview-refresh-pcrm': notifications_object_prod.telegram_critonly,
        'seq-check-pcrm': notifications_object_prod.telegram_critonly,
        'user-objects-in-sys-pcrm': notifications_object_prod.telegram_critonly,

        # TG - to developers, removed as per PAYSYSDBA-4474
    }
}
