from paysys.sre.tools.monitorings.lib.util.helpers import check, flaps, merge, ttl, unreach_skip, gen_unreach_by_service, gen_children
from paysys.sre.tools.monitorings.lib.checks import base, services, graphite
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip
from paysys.sre.tools.monitorings.configs.meta.base import database

host = "meta.stable.db"  # VIRT HOST
children = ['meta-rdbms']  # CGROUP

exclude_db_checks = ['oracle-status', 'shared_pool_free_mem', 'rm-logs',
                     'fk-indexing', 'matview-monitor', 'matview-refresh', 'mvlogmove', 'user-objects-in-sys']
exclude_rac_checks = ['oracle-patches']

database_global = services.oracle_database.copy()
database_project = database.get_checks(children)

database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]

rac_result = services.oracle_rac.copy()
[rac_result.pop(exclude) for exclude in exclude_rac_checks]

graphite_diskwait = graphite.graphite_check('metadb_diskwait',
                                            'highestMax(movingAverage(one_min.meta[12][fvh]_{paysys_yandex,yandex}_{net,ru}.diskstat_wait_sd*.wait,20),1)',
                                            warn_expr='metric > 20', crit_expr='metric > 30')
graphite_diskwait['metadb_diskwait'].pop('refresh_time')
graphite_diskwait['metadb_diskwait'].update(merge(ttl(300, 60), flaps(300, 1800)))


def checks():
    result = merge(base.common_fin_fin(children),
                   rac_result,
                   database_result,
                   services.mailq,
                   services.pipeline_sender,
                   services.audit,
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   check('oracle-balance-patches', merge(ttl(5400, 3600), logic_or, unreach_skip, downtime_skip)),
                   check('unispace5', merge(flaps(300, 900), ttl(620, 300), logic_or, unreach_skip, downtime_skip)),
                   # meta
                   check('oracle-status-meta1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-meta2', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('db-parameters-meta', merge(ttl(620, 300))),
                   check('db-file_locations-meta', merge(ttl(1800, 350))),
                   check('rm-logs-meta', merge(ttl(3700, 300))),
                   check('mvlogmove-meta', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('user-objects-in-sys-meta', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('s3backup-meta', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
                   check('store_audit-meta', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   # scat
                   check('oracle-status-scat1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-scat2', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('fk-indexing-scat', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('matview-monitor-scat', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('matview-refresh-scat', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('matview-refresh-scatnew1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('mvlogmove-scat', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('seq-check-scat', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('store_audit-scat', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('user-objects-in-sys-scat', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('db-parameters-scatnew', merge(ttl(620, 300))),
                   check('rm-logs-scatnew', merge(ttl(3700, 300))),
                   check('db-file_locations-scatnew', merge(ttl(1800, 350))),
                   check('s3backup-scatnew', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
                   # mhyp
                   check('oracle-status-mhypcdb1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('oracle-status-mhypcdb2', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('matview-refresh-mhypcdb1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('matview-monitor-mhypcdb1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('seq-check-mhypcdb1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('user-objects-in-sys-mhypcdb1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('db-parameters-mhyp', merge(ttl(620, 300))),
                   check('rm-logs-mhyp', merge(ttl(3700, 300))),
                   check('db-file_locations-mhyp', merge(ttl(1800, 350))),
                   check('store_audit-mhyp', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('s3backup-mhyp', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
                   # pcrm
                   check('db-parameters-pcrm', merge(ttl(620, 300))),
                   check('rm-logs-pcrm', merge(ttl(3700, 300))),
                   check('db-file_locations-pcrm', merge(ttl(1800, 350))),
                   check('fk-indexing-pcrm', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('matview-monitor-pcrm', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('matview-refresh-pcrm', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('mvlogmove-pcrm', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('seq-check-pcrm', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('store_audit-pcrm', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('user-objects-in-sys-pcrm', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('s3backup-pcrm', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
                   )
    result.pop('mount')
    result.pop('db-parameters')
    result.pop('db-file_locations')
    result.pop('store_audit')
    result = gen_unreach_by_service(result)
    return result
