from paysys.sre.tools.monitorings.lib.checks import base
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_skip, flaps, gen_unreach_by_service, gen_children
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip

host = "meta.stable.target"  # VIRT HOST
children = ['meta-targets']  # CGROUP


def checks():
    result = merge(base.common_fin_fin(children),
                   check('check-scst-portals', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('iscsi-scstd-alive', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('unispace5', merge(flaps(300, 900), ttl(620, 300), logic_or, unreach_skip, downtime_skip)),

                   )
    result.pop('mount')
    result = gen_unreach_by_service(result)
    return result
