from paysys.sre.tools.monitorings.lib.checks.base import common
from paysys.sre.tools.monitorings.lib.checks.doc import doc
from paysys.sre.tools.monitorings.lib.util.helpers import merge, flaps, ttl
from paysys.sre.tools.monitorings.lib.notifications import Notifications

TELEGRAM_GROUP = ["dkriv"]
IRON_WOMAN_DELAY = 1200
ESCALATION_USERS = [
    "dkriv"
]


notifications_object = Notifications()
notifications_object.set_telegram(TELEGRAM_GROUP)
notifications_object.set_iron_woman(logins=ESCALATION_USERS, delay=IRON_WOMAN_DELAY)


def checks_common(children):
    return merge(
        common(children),
        {
            "syslog-alive": doc("https://wiki.yandex-team.ru/dljaadminov/paysys/ps/syslog-ng/"),
            "push-client": merge(flaps(900, 3600), ttl(3780, 300)),
        },
    )
