from paysys.sre.tools.monitorings.configs.octopus.base import octopus
from paysys.sre.tools.monitorings.lib.util.helpers import merge
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import nginx_combaine_bundle
from paysys.sre.tools.monitorings.lib.checks.active.http import https_bundle
from paysys.sre.tools.monitorings.lib.checks.services import keepalived
from paysys.sre.tools.monitorings.lib.checks.base import pkgver, disk_ssd, cpu_usage

host = "octopus.octopus"

children = ['octopus']


def checks():
    return merge(
        pkgver,
        octopus.get_checks(children, 'octopus', 1),
        keepalived,
        https_bundle('records-server', port=8803, headers={'Host': 'records-server.paysys.yandex.net'}),
        https_bundle('octopus-admin', port=443, headers={'Host': 'octopus-admin.paysys.yandex-team.ru'}),
        https_bundle('octopus-stats', port=8804, headers={'Host': 'octopus-stats.paysys.yandex-team.ru'}),
        https_bundle('state-arbiter', port=8802, headers={'Host': 'state-arbiter.paysys.yandex-team.ru'}),
        nginx_combaine_bundle(conductor_children=children, combaine_env='prod', combaine_path='octopus.nginx-octopus.octopus'),
        disk_ssd(children),
        cpu_usage(children)
    )
