from paysys.sre.tools.monitorings.lib.notifications import Notifications, OEBS_ESCALATION_USERS

calendar_id = 27924

notifications_object_nonprod = Notifications()
notifications_object_nonprod.set_calendar(calendar_id)
notifications_object_nonprod.set_iron_woman(logins=OEBS_ESCALATION_USERS, delay=420)
notifications_object_nonprod.set_startrek('OEBSADMIN', status='CRIT', components='monitoring', priority='normal')
notifications_object_nonprod.set_telegram('yndx-oebs-duty-monitoring')

notifications_object_prod = Notifications()
notifications_object_prod.set_calendar(calendar_id)
notifications_object_prod.set_iron_woman(logins=OEBS_ESCALATION_USERS)
notifications_object_prod.set_startrek('OEBSADMIN', status='CRIT', components='monitoring', priority='normal')
notifications_object_prod.set_telegram('yndx-oebs-duty-monitoring')

notifications_object_public = Notifications()
notifications_object_public.set_telegram(['yndx-oebs-admin', 'chat_oebs_release'])

notifications_object_prod_public = Notifications()
notifications_object_prod_public.set_startrek('OEBSADMIN', status='CRIT', components='monitoring', priority='critical')
notifications_object_prod_public.set_calendar(calendar_id)
notifications_object_prod_public.set_iron_woman(logins=OEBS_ESCALATION_USERS)
notifications_object_prod_public.set_telegram('yndx-oebs-admin')

notifications_object_prod_admin = Notifications()
notifications_object_prod_admin.set_startrek('OEBSADMIN', status='CRIT', components='monitoring', priority='normal')
notifications_object_prod_admin.set_calendar(calendar_id)
notifications_object_prod_admin.set_iron_woman(logins=OEBS_ESCALATION_USERS)
notifications_object_prod_admin.set_telegram('yndx-oebs-admin-group')

notifications_nonprod = {
    # tracker
    'default': notifications_object_nonprod.startrek,
    'by_service': {
        # iron_woman
        'UNREACHABLE': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,
        'uptime': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,
        'grid-up': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,
        'database-up': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,
        'oebs-up': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,
        'load_average_paysys': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,
        'nginx-alive': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,
        'failed_locks': notifications_object_nonprod.iron_woman_and_telegram_critonly,
        'workflow': notifications_object_nonprod.iron_woman_daytime_and_telegram_critonly,

        # tracker + telegram
        'asm-status-ng': notifications_object_nonprod.startrek_and_telegram_critonly,
        'autopatch': notifications_object_nonprod.startrek_and_telegram_critonly,
        'hbf_service_status': notifications_object_nonprod.startrek_and_telegram_critonly,
        'host_memory_usage': notifications_object_nonprod.startrek_and_telegram_critonly,
        'hwerrors2': notifications_object_nonprod.startrek_and_telegram_critonly,
        'iscsi-ips': notifications_object_nonprod.startrek_and_telegram_critonly,
        'iscsi-params': notifications_object_nonprod.startrek_and_telegram_critonly,
        'net_services': notifications_object_nonprod.startrek_and_telegram_critonly,
        'stunnel': notifications_object_nonprod.startrek_and_telegram_critonly,
        'opp_check': notifications_object_nonprod.startrek_and_telegram_critonly,
        'ro-services': notifications_object_nonprod.startrek_and_telegram_critonly,
        'weblogic': notifications_object_nonprod.startrek_and_telegram_critonly,
        's3backup-oebs': notifications_object_nonprod.startrek_and_telegram_critonly,

        # telegram
        'check_slb': notifications_object_nonprod.telegram_critonly,
        'haproxy': notifications_object_nonprod.telegram_critonly,
        'jmx2graphite-config-generator': notifications_object_nonprod.telegram_critonly,
        'jmx2graphite-process': notifications_object_nonprod.telegram_critonly,
        'mount': notifications_object_nonprod.telegram_critonly,
        'nginx-errors': notifications_object_nonprod.telegram_critonly,
        'ntp-stratum': notifications_object_nonprod.telegram_critonly,
        'paysys-common-settings': notifications_object_nonprod.telegram_critonly,
        'unbound': notifications_object_nonprod.telegram_critonly,
        'XXSA': notifications_object_public.telegram_critonly,
        'cpu_utilize': notifications_object_nonprod.telegram_critonly,
        'ping-oebsapi': notifications_object_nonprod.telegram_critonly,
        'ping-wto': notifications_object_nonprod.telegram_critonly,
        'staled_clients': notifications_object_nonprod.telegram_critonly,
        'staled_locks': notifications_object_nonprod.telegram_critonly,
        'unfetched_locks': notifications_object_nonprod.telegram_critonly,

        # juggler
        'oebs-apache': notifications_object_nonprod.noop,
        'oracleasm_iid_cnt': notifications_object_nonprod.noop,
        'oracle-status': notifications_object_nonprod.noop,
        'oracle_memory_usage': notifications_object_nonprod.noop,
        'outsource-mailer': notifications_object_nonprod.noop,
        'ps_segment_info': notifications_object_nonprod.noop,
        'ps_ts_info': notifications_object_nonprod.noop,
        'psdbstat': notifications_object_nonprod.noop,
        'raid_check_speed': notifications_object_nonprod.noop,
        'tvm_health': notifications_object_nonprod.noop,
        'watchdog': notifications_object_nonprod.noop,
    }
}


notifications_prod = {
    # tracker
    'default': notifications_object_prod.startrek,
    'by_service': {
        # iron_woman
        'UNREACHABLE': notifications_object_prod.iron_woman_and_telegram_critonly,
        'uptime': notifications_object_prod.iron_woman_and_telegram_critonly,
        'grid-up': notifications_object_prod.iron_woman_and_telegram_critonly,
        'database-up': notifications_object_prod.iron_woman_and_telegram_critonly,
        'oracle_uptime': notifications_object_prod_public.iron_woman_and_startrek_and_telegram_critonly,
        'oracle_uptime_standby': notifications_object_prod_admin.iron_woman_and_startrek_and_telegram_critonly,
        'oebs-up': notifications_object_prod.iron_woman_and_telegram_critonly,
        'load_average_paysys': notifications_object_prod.iron_woman_and_telegram_critonly,
        'mail_queue': notifications_object_prod.iron_woman_daytime_and_telegram_critonly,
        'net_services': notifications_object_prod.iron_woman_daytime_and_startrek_critonly,
        'nginx-alive': notifications_object_prod.iron_woman_and_telegram_critonly,
        'oracle_memory_usage': notifications_object_prod.iron_woman_and_telegram_critonly,
        'raid': notifications_object_prod.iron_woman_daytime_and_startrek_critonly,
        'shared_pool_free_mem': notifications_object_prod.iron_woman_and_telegram_critonly,
        'standby-lag': notifications_object_prod.iron_woman_and_telegram_critonly,
        'bot_queue_size': notifications_object_prod.iron_woman_and_telegram_critonly,
        'icm': notifications_object_prod.iron_woman_and_telegram_critonly,
        'java-OOM-count': notifications_object_prod.iron_woman_and_telegram_critonly,
        'locker-server': notifications_object_prod.iron_woman_and_telegram_critonly,
        'oebs_notify': notifications_object_prod.iron_woman_daytime,
        'opp_check': notifications_object_prod.iron_woman_and_telegram_critonly,
        'outsource-mailer': notifications_object_prod.iron_woman_daytime,
        'pending_requests': notifications_object_prod.iron_woman_and_telegram_critonly,
        'ping-oebsapi': notifications_object_prod.iron_woman_and_telegram_critonly,
        'rwrun': notifications_object_prod.iron_woman_and_telegram_critonly,
        'scheduler': notifications_object_prod.iron_woman_and_telegram_critonly,
        'tar-apps': notifications_object_prod.iron_woman_and_telegram_critonly,
        'weblogic': notifications_object_prod.iron_woman_and_telegram_critonly,
        'workflow': notifications_object_prod.iron_woman_and_telegram_critonly,
        'unispace5': notifications_object_prod.iron_woman_and_telegram_critonly,
        'apps_java-forms': notifications_object_prod.iron_woman_daytime_and_startrek_and_telegram_critonly,
        'stalled_concurrents': notifications_object_prod.iron_woman_daytime_and_telegram_critonly,

        # tracker + telegram
        'asm-status-ng': notifications_object_prod.startrek_and_telegram_critonly,
        'autopatch': notifications_object_prod.startrek_and_telegram_critonly,
        'db-parameters': notifications_object_prod.startrek_and_telegram_critonly,
        'gluster_health': notifications_object_prod.startrek_and_telegram_critonly,
        'hbf_service_last_update_status': notifications_object_prod.startrek_and_telegram_critonly,
        'hbf_service_status': notifications_object_prod.startrek_and_telegram_critonly,
        'host_memory_usage': notifications_object_prod.startrek_and_telegram_critonly,
        'hugepages': notifications_object_prod.startrek_and_telegram_critonly,
        'hwerrors2': notifications_object_prod.startrek_and_telegram_critonly,
        'iscsi-ips': notifications_object_prod.startrek_and_telegram_critonly,
        'iscsi-params': notifications_object_prod.startrek_and_telegram_critonly,
        'ldaps': notifications_object_prod.startrek_and_telegram_critonly,
        'link-speed': notifications_object_prod.startrek_and_telegram_critonly,
        'nginx-errors': notifications_object_prod.startrek_and_telegram_critonly,
        'rm-logs': notifications_object_prod.startrek_and_telegram_critonly,
        'runbackup_rman': notifications_object_prod.startrek_and_telegram_critonly,
        'stunnel': notifications_object_prod.startrek_and_telegram_critonly,
        'switch_uplink_drop': notifications_object_prod.startrek_and_telegram_critonly,
        'switch_uplink_errs': notifications_object_prod.startrek_and_telegram_critonly,
        'switch_uplink_flaps': notifications_object_prod.startrek_and_telegram_critonly,
        'switch_uplink_utilization': notifications_object_prod.startrek_and_telegram_critonly,
        'OACore_monitor': notifications_object_prod.startrek_and_telegram_critonly,
        'adop-nodes': notifications_object_prod.startrek_and_telegram_critonly,
        'common-dirs': notifications_object_prod.startrek_and_telegram_critonly,
        'context_files': notifications_object_prod.startrek_and_telegram_critonly,
        'ebs_homes': notifications_object_prod.startrek_and_telegram_critonly,
        'etcc-check': notifications_object_prod.startrek_and_telegram_critonly,
        'httpd-webdav': notifications_object_prod.startrek_and_telegram_critonly,
        'monitor_custom': notifications_object_prod.startrek_and_telegram_critonly,
        'oracle-status': notifications_object_prod.startrek_and_telegram_critonly,
        'ro-services': notifications_object_prod.startrek_and_telegram_critonly,
        'tomcat-alive': notifications_object_prod.startrek_and_telegram_critonly,
        'wf_bgproc_check': notifications_object_prod.startrek_and_telegram_critonly,
        'unispace': notifications_object_prod.startrek_and_telegram_critonly,
        'editions': notifications_object_prod.startrek_and_telegram_critonly,

        # telegram
        'check_slb': notifications_object_prod.telegram_critonly,
        'haproxy': notifications_object_prod.telegram_critonly,
        'jmx2graphite-config-generator': notifications_object_prod.telegram_critonly,
        'jmx2graphite-process': notifications_object_prod.telegram_critonly,
        'mount': notifications_object_prod.telegram_critonly,
        'ntp-stratum': notifications_object_prod.telegram_critonly,
        'paysys-common-settings': notifications_object_prod.telegram_critonly,
        'unbound': notifications_object_prod.telegram_critonly,
        'XXSA': notifications_object_public.telegram_critonly,
        'cpu_utilize': notifications_object_prod.telegram_critonly,
        'ping-wto': notifications_object_prod.telegram_critonly,

        # Disabled aggregates
        'XXSA_applf': {},
        'XXSA_applh': {},
        'XXSA_applv': {},
        'keystore-certs_applf': {},
        'keystore-certs_applh': {},
        'keystore-certs_applv': {},
        'nginx-errors_applf': {},
        'nginx-errors_applh': {},
        'nginx-errors_applv': {},
        'oebs-apache_applf': {},
        'oebs-apache_applh': {},
        'oebs-apache_applv': {},
        'opp_check_applf': {},
        'opp_check_applh': {},
        'opp_check_applv': {},
        'editions_applf': {},
        'editions_applh': {},
        'editions_applv': {},

        # Food-exchange PAYSYSADMIN-8697
        'food-exchange': notifications_object_prod.iron_woman_daytime_and_telegram_critonly,
        'food-alive': notifications_object_prod.iron_woman_and_telegram_critonly,

        # juggler
        'oebs-apache': notifications_object_prod.noop,
        'oracleasm_iid_cnt': notifications_object_prod.noop,
        'ps_segment_info': notifications_object_prod.noop,
        'ps_ts_info': notifications_object_prod.noop,
        'psdbstat': notifications_object_prod.noop,
        'raid_check_speed': notifications_object_prod.noop,
        'watchdog': notifications_object_prod.noop,
    }
}
