from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, gen_children, flaps, unreach_skip
from paysys.sre.tools.monitorings.lib.checks.doc import doc_link
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip, more_than_limit_is_crit


def get_checks(children):
    appl = {
        'OACore_monitor': merge(ttl(300, 120), doc_link('oebs.paysys')),
        'XXSA': merge(ttl(700, 300), logic_or, unreach_skip, downtime_skip, doc_link('oebs.paysys'), {'tags': ['no_tags']}),
        'autopatch': merge(ttl(620, 300), logic_and, unreach_skip, downtime_skip, doc_link('oebs.paysys')),
        'cpu_utilize': merge(ttl(620, 300), doc_link('oebs.paysys')),
        'ebs_homes': merge(ttl(700, 300), doc_link('oebs.paysys')),
        'icm': merge(ttl(620, 300), logic_or, unreach_skip, downtime_skip, doc_link('oebs.paysys')),
        'java-OOM-count': merge(ttl(700, 300), doc_link('oebs.paysys')),
        'oebs-apache': merge(flaps(480, 600), ttl(630, 330), doc_link('oebs.paysys')),
        'opp_check': merge(flaps(900, 1500), ttl(630, 330), logic_and, unreach_skip, downtime_skip, doc_link('oebs.paysys')),
        'opp_flap': merge(flaps(900, 1500), ttl(630, 330), logic_and, unreach_skip, downtime_skip, doc_link('oebs.paysys')),
        'outsource-mailer': merge(ttl(700, 300), doc_link('oebs.paysys')),
        'pending_requests': merge(flaps(900, 0), ttl(700, 300), more_than_limit_is_crit(2), unreach_skip, downtime_skip, doc_link('oebs.paysys')),
        'rwrun': merge(ttl(700, 300), doc_link('oebs.paysys')),
        'tvm_health': merge(ttl(600, 300), gen_children(children, ['tvm_ping'])),
        'weblogic': merge(flaps(900, 0), ttl(630, 330), doc_link('oebs.paysys')),
        'wf_bgproc_check': merge(flaps(900, 1500), ttl(320, 70), doc_link('oebs.paysys'), logic_and, unreach_skip, downtime_skip,),
        'workflow': merge(ttl(700, 300), doc_link('oebs.paysys')),
    }

    appl.update(check('oebs_ports', merge(gen_children(children, 'ports'), doc_link('oebs.paysys'))))  # TODO rename

    return appl


def get_checks_rac(children):
    appl_rac = {'context_files': merge(ttl(620, 250), logic_or, unreach_skip, downtime_skip, doc_link('oebs.paysys'))}
    return appl_rac
