from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, unreach_skip, gen_children
from paysys.sre.tools.monitorings.lib.checks.doc import doc_link
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip


def get_checks(children):
    database = {
        'ebs-processes': merge(ttl(700, 300), logic_and, unreach_skip, downtime_skip, doc_link('oebs.paysys')),
        'etcc-check': merge(ttl(2500, 2000), logic_and, unreach_skip, downtime_skip, doc_link('oebs.paysys')),
        'tvm_health': merge(ttl(600, 300), gen_children(children, ['tvm_ping'])),
    }

    return database


def get_checks_rac(children):
    database_rac = {'adop-nodes': merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, doc_link('oebs.paysys'))}

    return database_rac
