from paysys.sre.tools.monitorings.lib.util.helpers import check, gen_children, merge, gen_unreach_by_service, flaps, ttl, unreach_skip
from paysys.sre.tools.monitorings.configs.oebs.base import appl
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, downtime_skip

host = "oebs.prestable.appl"  # VIRT HOST
children = ['oebs_inf_apps']  # CGROUP


def checks():
    ldap_modif = services.ldap.copy()
    ldap_modif.pop('ldap-limits')

    base_checks = base.common_fin_fin(children)
    _ = base_checks.pop('host_memory_usage')

    result = merge(
        base_checks,
        services.nginx,
        services.oracle_rac,
        ldap_modif,
        services.yandex_cauth_cache,
        services.haproxy,
        services.stunnel,
        appl.get_checks(children),
        appl.get_checks_rac(children),
        services.sslcerts,
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                               logic_or, unreach_skip, downtime_skip)),
        check('check_acfs', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'check_acfs'),
                                  logic_or, unreach_skip, downtime_skip)),
    )
    result = gen_unreach_by_service(result)
    return result
