from paysys.sre.tools.monitorings.configs.oebs.base import database
from paysys.sre.tools.monitorings.lib.util.helpers import check, gen_children, merge, gen_unreach_by_service, flaps, ttl, unreach_skip
from paysys.sre.tools.monitorings.lib.checks import base, services
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, downtime_skip

host = "oebs.prestable.db"  # VIRT HOST
children = ['oebs_inf_db']  # CGROUP
exclude_db_checks = [
    'standby-lag', 'rm-logs', 'ro-services', 'db-parameters',
    'db-file_locations', 'ps_ts_info', 'ps_segment_info', 'ebs-processes', 'mvlogmove',
    'matview-refresh', 'matview-monitor', 'fk-indexing'
]

modif_db_checks = [
    'shared_pool_free_mem', 'user-objects-in-sys', 'etcc-check'
]

children_db_first_node = ['dbtest01v.oebs.yandex.net']
children_db_second_node = ['dbtest02v.oebs.yandex.net']


def checks():
    ldap_modif = services.ldap.copy()
    ldap_modif.pop('ldap-limits')

    database_global = services.oracle_database.copy()
    database_project = database.get_checks(children)

    database_result = merge(database_global, database_project)
    [database_result.pop(exclude) for exclude in exclude_db_checks]
    [database_result[modif].update(logic_or) for modif in modif_db_checks]

    base_checks = base.common_fin_fin(children)
    _ = base_checks.pop('host_memory_usage')

    result = merge(
        base_checks,
        services.oracle_rac,
        database_result,
        ldap_modif,
        services.haproxy,
        services.stunnel,
        database.get_checks_rac(children),
        services.sslcerts,
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                               logic_or, unreach_skip, downtime_skip)),
        check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                   logic_or, unreach_skip, downtime_skip)),
    )
    result = gen_unreach_by_service(result)
    return result
