from paysys.sre.tools.monitorings.lib.util.helpers import check, gen_children, merge, gen_unreach_by_service, flaps, ttl, unreach_skip
from paysys.sre.tools.monitorings.lib.checks import base
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip

host = "oebs.prestable.target"  # VIRT HOST
children = ['oebs_inf_storage']  # CGROUP


def checks():
    base_checks = base.common_fin_fin(children)
    _ = base_checks.pop('host_memory_usage')

    result = merge(
        base_checks,
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('apps_web-forms', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'apps_web-forms'),
                                      logic_and, unreach_skip, downtime_skip)),
        check('apps_java-forms', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'apps_java-forms'),
                                       logic_and, unreach_skip, downtime_skip)),
    )
    result = gen_unreach_by_service(result)
    return result
