from paysys.sre.tools.monitorings.configs.oebs.base import appl
from paysys.sre.tools.monitorings.lib.util.helpers import check, flaps, gen_children, merge, ttl, unreach_force_ok, unreach_skip, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services, doc
from paysys.sre.tools.monitorings.lib.checks.active.http import https_cert
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip, logic_or, more_than_limit_is_crit

host = "oebs.stable.appl"  # VIRT HOST
children = ['oebs_prod_apps']  # CGROUP
children_appl_first_node = ['appl1f.oebs.yandex.net', 'appl1v.oebs.yandex.net', 'appl1h.oebs.yandex.net']
children_applf = ['appl1f.oebs.yandex.net', 'appl2f.oebs.yandex.net', 'appl3f.oebs.yandex.net']
children_applv = ['appl1v.oebs.yandex.net', 'appl2v.oebs.yandex.net', 'appl3v.oebs.yandex.net']
children_applh = ['appl1h.oebs.yandex.net', 'appl2h.oebs.yandex.net', 'appl3h.oebs.yandex.net']
children_all = children_applf+children_applv+children_applh


def checks():
    appl_checks = appl.get_checks(children).copy()
    appl_checks.pop('opp_check')
    appl_checks.pop('XXSA')

    # Warden tags
    appl_checks['pending_requests']['tags'] = [
        'warden_functionality_oebs_apps_concurrent-requests',
        'warden_auto_source',
        'warden_alert_create_spi',
        'warden_alert_start_flow'
    ]

    result = merge(
        base.common_fin_fin(children),
        services.oracle_rac,
        services.ldap,
        services.check_slb,
        services.haproxy,
        services.keepalived,
        services.mailq,
        services.nginx,
        services.sslcerts,
        services.stunnel,
        appl_checks,
        appl.get_checks_rac(children),
        check('opp_check_applf',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applf, 'opp_check', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('opp_check_applv',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applv, 'opp_check', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('opp_check_applh',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applh, 'opp_check', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('opp_check', merge(flaps(900, 1500), ttl(630, 330), gen_children(host,
                                                                               ['opp_check_applf',
                                                                                'opp_check_applv',
                                                                                'opp_check_applh'], 'HOST'),
                                 unreach_skip, downtime_skip, logic_or, doc.doc_link('oebs.paysys'))),
        check('keystore-certs_applf',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applf, 'keystore-certs', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('keystore-certs_applv',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applv, 'keystore-certs', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('keystore-certs_applh',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applh, 'keystore-certs', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('keystore-certs', merge(flaps(900, 1500), ttl(630, 330), gen_children(host,
                                                                                    ['keystore-certs_applf',
                                                                                     'keystore-certs_applv',
                                                                                     'keystore-certs_applh'], 'HOST'),
                                      unreach_skip, downtime_skip, logic_or, doc.doc_link('oebs.paysys'))),
        check('XXSA_applf',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applf, 'XXSA', 'HOST'),
                    logic_and, unreach_skip, downtime_skip)),
        check('XXSA_applv',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applv, 'XXSA', 'HOST'),
                    logic_and, unreach_skip, downtime_skip)),
        check('XXSA_applh',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applh, 'XXSA', 'HOST'),
                    logic_and, unreach_skip, downtime_skip)),
        check('XXSA', merge(flaps(900, 1500), ttl(630, 330), gen_children(host,
                                                                          ['XXSA_applf',
                                                                           'XXSA_applv',
                                                                           'XXSA_applh'], 'HOST'),
                            unreach_skip, downtime_skip, logic_or, doc.doc_link('oebs.paysys'))),
        check('nginx-errors_applf',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applf, 'nginx-errors', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('nginx-errors_applv',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applv, 'nginx-errors', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('nginx-errors_applh',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applh, 'nginx-errors', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('nginx-errors', merge(flaps(480, 600), ttl(630, 330), gen_children(host,
                                                                                 ['nginx-errors_applf',
                                                                                  'nginx-errors_applv',
                                                                                  'nginx-errors_applh'], 'HOST'), unreach_skip, downtime_skip, logic_and, doc.doc_link('oebs.paysys'))),
        check('oebs-apache_applf',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applf, 'oebs-apache', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('oebs-apache_applv',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applv, 'oebs-apache', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('oebs-apache_applh',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applh, 'oebs-apache', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('oebs-apache', merge(flaps(480, 600), ttl(630, 330), gen_children(host,
                                                                                ['oebs-apache_applf',
                                                                                 'oebs-apache_applv',
                                                                                 'oebs-apache_applh'], 'HOST'),
                                   unreach_skip, downtime_skip, logic_and, doc.doc_link('oebs.paysys'))),
        check('bot_queue_size', logic_and, unreach_skip, downtime_skip, doc.doc_link('oebs.paysys')),
        check('httpd-webdav', merge(gen_children(children_appl_first_node, 'httpd-webdav', 'HOST'),
                                    doc.doc_link('oebs.paysys'))),
        https_cert('https_certificate', port=443, warn=30, crit=14, host='appl.oebs.yandex.net',
                   ssl_host='appl.oebs.yandex.net'),
        check('monitor_custom', ttl(3700, 300), unreach_force_ok, doc.doc_link('oebs.paysys')),
        check('oebs_notify', logic_and, unreach_skip, downtime_skip, doc.doc_link('oebs.paysys')),
        check('prn_stat', doc.doc_link('oebs.paysys')),
        check('tar-apps', merge(gen_children(children_appl_first_node, 'tar-apps', 'HOST'),
                                doc.doc_link('oebs.paysys'))),
        check('check_acfs', merge(flaps(900, 0), ttl(630, 330), gen_children(children_appl_first_node, 'check_acfs', 'HOST'),
                                  doc.doc_link('oebs.paysys'))),
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                               logic_or, unreach_skip, downtime_skip)),
        check('unispace5', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'unispace5'),
                                 logic_or, unreach_skip, downtime_skip)),
        check('stalled_concurrents', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'stalled_concurrents'),
                                           more_than_limit_is_crit(2), unreach_skip, downtime_skip)),
        check('editions_applf',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applf, 'editions', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('editions_applv',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applv, 'editions', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('editions_applh',
              merge(flaps(900, 1500), ttl(630, 330), gen_children(children_applh, 'editions', 'HOST'),
                    logic_or, unreach_skip, downtime_skip)),
        check('editions', merge(flaps(900, 1500), ttl(630, 330), gen_children(host,
                                                                               ['editions_applf',
                                                                                'editions_applv',
                                                                                'editions_applh'], 'HOST'),
                                 unreach_skip, downtime_skip, logic_or, doc.doc_link('oebs.paysys'))),
    )
    result = gen_unreach_by_service(result)
    return result
