from paysys.sre.tools.monitorings.configs.oebs.base import database
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, gen_children, check, unreach_skip, flaps, gen_unreach_by_service
from paysys.sre.tools.monitorings.lib.checks import base, services, doc
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip, logic_or

host = "oebs.stable.db"  # VIRT HOST
children = ['oebs_prod_db']  # CGROUP
children_db_first_node = ['db1f.oebs.yandex.net', 'db1h.oebs.yandex.net', 'db1v.oebs.yandex.net']
children_db_second_node = ['db2f.oebs.yandex.net', 'db2h.oebs.yandex.net', 'db2v.oebs.yandex.net']

# OEBSADMIN-26424
exclude_db_checks = [
    'matview-refresh', 'matview-monitor', 'fk-indexing'
]
database_global = services.oracle_database.copy()
database_project = database.get_checks(children)
database_result = merge(database_global, database_project)
[database_result.pop(exclude) for exclude in exclude_db_checks]


def checks():
    result = merge(
        base.common_fin_fin(children),
        services.oracle_rac,
        database_result,
        services.haproxy,
        services.mailq,
        services.audit,
        services.sslcerts,
        services.stunnel,
        database.get_checks_rac(children),
        check('oracle_uptime', merge(ttl(630, 330), gen_children(children, 'oracle_uptime'),
                                     logic_or, unreach_skip, downtime_skip, {'tags': ['no_tags']})),
        check('oracle_uptime_standby', merge(ttl(630, 330), gen_children(children, 'oracle_uptime_standby'),
                                             logic_or, unreach_skip, downtime_skip, {'tags': ['no_tags']})),
        check('common-dirs', logic_and, unreach_skip, downtime_skip, doc.doc_link('oebs.paysys')),
        check('oebs_syncer', merge(gen_children(children_db_first_node, 'oebs_syncer', 'HOST'), doc.doc_link('oebs.paysys'))),
        check('oebs-one-min', doc.doc_link('oebs.paysys')),
        check('oebs-five-min', doc.doc_link('oebs.paysys')),
        check('oebs-one-hour', ttl(3700, 1800), doc.doc_link('oebs.paysys')),
        check('oebs-one-day', ttl(87000, 1800), doc.doc_link('oebs.paysys')),
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                               logic_or, unreach_skip, downtime_skip)),
        check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                   logic_or, unreach_skip, downtime_skip)),
        check('unispace5', merge(flaps(300, 900), ttl(620, 300), logic_or, unreach_skip, downtime_skip)),
        check('s3backup-oebs', merge(flaps(300, 900), ttl(3700, 1800), logic_or, unreach_skip, downtime_skip)),
    )
    result = gen_unreach_by_service(result)
    return result
